/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.admin.Subtasks;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class SubtasksImpl
implements Subtasks {
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final FuncTestLoggerImpl logger;
    private Navigation navigation;

    public SubtasksImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.logger = new FuncTestLoggerImpl(2);
    }

    @Override
    public void enable() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        if (this.tester.getDialog().isLinkPresent("enable_subtasks")) {
            this.logger.log((Object)"Enabling sub-tasks");
            this.tester.clickLink("enable_subtasks");
        }
    }

    @Override
    public void disable() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        if (this.tester.getDialog().isLinkPresent("disable_subtasks")) {
            this.logger.log((Object)"Disabling sub-tasks");
            this.tester.clickLink("disable_subtasks");
        }
    }

    @Override
    public boolean isEnabled() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        HtmlPage page = new HtmlPage(this.tester);
        return page.isLinkPresentWithExactText("Disable");
    }

    @Override
    public void addSubTaskType(String subTaskName, String subTaskDescription) {
        this.enable();
        this.tester.clickLink("add-subtask-type");
        this.tester.setFormElement("name", subTaskName);
        this.tester.setFormElement("description", subTaskDescription);
        this.tester.submit("Add");
    }

    @Override
    public void deleteSubTaskType(String subTaskName) {
        this.enable();
        this.tester.clickLink("del_" + subTaskName);
        this.tester.submit("Delete");
    }

    private Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        return this.navigation;
    }
}

