/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.UsersAndGroups;
import com.atlassian.jira.functest.framework.admin.user.EditUserPage;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class UsersAndGroupsImpl
implements UsersAndGroups {
    private static final String PAGE_USER_BROWSER = "/secure/admin/user/UserBrowser.jspa";
    private static final String PAGE_CREATE_USER = "/secure/admin/user/AddUser!default.jspa";
    private static final String DELETE_GROUP = "/secure/admin/user/DeleteGroup!default.jspa?name=";
    private static final String PAGE_VIEW_USER = "/secure/admin/user/ViewUser.jspa?name=";
    private final TextAssertions text;
    private final Navigation navigation;
    private final LocatorFactory locators;
    private final WebTester tester;

    @Inject
    public UsersAndGroupsImpl(WebTester tester, Navigation navigation, TextAssertions text, LocatorFactory locators) {
        this.tester = tester;
        this.text = text;
        this.navigation = navigation;
        this.locators = locators;
    }

    @Override
    public void addUser(String username) {
        this.addUser(username, username, username, username + "@example.com");
    }

    @Override
    public boolean userExists(String username) {
        this.tester.gotoPage(PAGE_USER_BROWSER);
        return this.tester.getDialog().isLinkPresent(username);
    }

    @Override
    public void addUser(String username, String password, String fullname, String emailAddress) {
        this.addUser(username, password, fullname, emailAddress, false);
    }

    @Override
    public void addUser(String username, String password, String fullname, String emailAddress, boolean sendEmail) {
        this.addUserWithoutVerifyingResult(username, password, fullname, emailAddress, sendEmail);
        this.gotoViewUser(username);
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Username:", username, "Full name:", fullname, "Email:", emailAddress});
    }

    @Override
    public void addUserWithoutVerifyingResult(String username, String password, String fullname, String emailAddress) {
        this.addUserWithoutVerifyingResult(username, password, fullname, emailAddress, false);
    }

    @Override
    public void addUserWithoutVerifyingResult(String username, String password, String fullname, String emailAddress, boolean sendEmail) {
        this.tester.gotoPage(PAGE_CREATE_USER);
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", password);
        this.tester.setFormElement("fullname", fullname);
        this.tester.setFormElement("email", emailAddress);
        if (sendEmail) {
            this.tester.setFormElement("sendEmail", "true");
        } else {
            this.tester.uncheckCheckbox("sendEmail");
        }
        this.tester.submit("Create");
    }

    @Override
    public void deleteUser(String username) {
        this.tester.gotoPage(PAGE_USER_BROWSER);
        this.tester.clickLink("deleteuser_link_" + username);
        this.tester.assertTextPresent("Delete User: " + username);
        this.tester.submit("Delete");
        this.gotoViewUser(username);
        this.tester.assertTextPresent("User does not exist");
    }

    @Override
    public void deleteGroup(String groupname) {
        this.tester.gotoPage(DELETE_GROUP + groupname);
        this.tester.assertTextPresent("Delete Group: " + groupname);
        this.tester.submit("Delete");
    }

    @Override
    public void gotoViewUser(String username) {
        this.tester.gotoPage(PAGE_VIEW_USER + username);
    }

    @Override
    public void gotoUserBrowser() {
        this.tester.gotoPage(PAGE_USER_BROWSER);
    }

    @Override
    public EditUserPage gotoEditUser(String username) {
        this.navigation.gotoPage("secure/admin/user/EditUser!default.jspa?editName=" + username);
        return new EditUserPage(this.tester);
    }

    @Override
    public void addUserToGroup(String userName, String groupName) {
        this.gotoViewUser(userName);
        this.tester.clickLink("editgroups_link");
        try {
            FormParameterUtil form = new FormParameterUtil(this.tester, "user-edit-groups", "join");
            form.addOptionToHtmlSelect("groupsToJoin", new String[]{groupName});
            form.setFormElement("groupsToJoin", groupName);
            form.submitForm();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.gotoViewUser(userName);
        this.tester.assertTextPresent(groupName);
    }

    @Override
    public void addGroup(String groupName) {
        this.tester.gotoPage("/secure/admin/user/GroupBrowser.jspa");
        if (this.tester.getDialog().isLinkPresentWithText(groupName)) {
            this.tester.clickLink("del_" + groupName);
            this.tester.submit("Delete");
        }
        this.tester.setFormElement("addName", groupName);
        this.tester.submit();
        this.tester.assertLinkPresentWithText(groupName);
    }

    @Override
    public void removeUserFromGroup(String userName, String groupName) {
        this.gotoViewUser(userName);
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToLeave", groupName);
        this.tester.submit("leave");
        this.gotoViewUser(userName);
        this.text.assertTextNotPresent(this.locators.id("groups"), groupName);
    }
}

