/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin.plugins;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.util.dbc.Assertions;

public abstract class AbstractPluginModule {
    protected final String pluginKey;
    protected final Administration administration;

    protected AbstractPluginModule(String pluginKey, Administration administration) {
        this.pluginKey = Assertions.notNull("pluginKey", pluginKey);
        this.administration = administration;
    }

    public abstract String moduleKey();

    public abstract String moduleName();

    public final String completeModuleKey() {
        return this.pluginKey + ":" + this.moduleKey();
    }

    public final void disable() {
        this.administration.plugins().disablePluginModule(this.pluginKey, this.completeModuleKey());
    }

    public final void enable() {
        this.administration.plugins().enablePluginModule(this.pluginKey, this.completeModuleKey());
    }

    public final boolean isEnabled() {
        return this.administration.plugins().isPluginModuleEnabled(this.pluginKey, this.completeModuleKey());
    }

    public final boolean isInstalled() {
        return this.administration.plugins().isPluginInstalled(this.pluginKey);
    }
}

