/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.CommentAssertions;
import com.atlassian.jira.functest.framework.assertions.DashboardAssertions;
import com.atlassian.jira.functest.framework.assertions.DashboardAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.DefaultCommentAssertions;
import com.atlassian.jira.functest.framework.assertions.HTMLAssertions;
import com.atlassian.jira.functest.framework.assertions.HTMLAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.JiraFormAssertions;
import com.atlassian.jira.functest.framework.assertions.JiraFormAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.JiraMessageAssertions;
import com.atlassian.jira.functest.framework.assertions.JiraMessageAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.LabelAssertions;
import com.atlassian.jira.functest.framework.assertions.LabelAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.LinkAssertions;
import com.atlassian.jira.functest.framework.assertions.LinkAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.PluginAssertions;
import com.atlassian.jira.functest.framework.assertions.PluginAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.ProjectFieldsAssertions;
import com.atlassian.jira.functest.framework.assertions.ProjectFieldsAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.RequestAssertions;
import com.atlassian.jira.functest.framework.assertions.SidebarAssertions;
import com.atlassian.jira.functest.framework.assertions.SidebarAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.TableAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.URLAssertions;
import com.atlassian.jira.functest.framework.assertions.URLAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.UserAssertions;
import com.atlassian.jira.functest.framework.assertions.ViewIssueAssertions;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistorySet;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.testkit.client.restclient.ChangeLog;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.WebLink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.xml.sax.SAXException;

public class AssertionsImpl
implements Assertions {
    private final Backdoor backdoor;
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final Navigation navigation;
    private final LocatorFactory locator;
    private TextAssertions textAssertions;
    private URLAssertions urlAssertions;
    private JiraFormAssertions jiraFormAssertions;
    private IssueNavigatorAssertions issueNavigatorAssertions;
    private DashboardAssertions dashboardAssertions;
    private LinkAssertions linkAssertions;
    private TableAssertions tableAssertions;
    private LabelAssertions labelAssertions;
    private UserAssertions userAssertions;
    private HTMLAssertions htmlAssertions;
    private ViewIssueAssertions viewIssueAssertions;
    private JiraMessageAssertions jiraMessageAssertions;
    private PluginAssertions pluginAssertions;
    private ProjectFieldsAssertions projectFieldsAssertions;
    private RequestAssertions requestAssertions;
    private SidebarAssertions sidebarAssertions;
    @Inject
    private Parser parser;

    @Inject
    public AssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, LocatorFactory locator, Backdoor backdoor) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.navigation = navigation;
        this.locator = locator;
        this.backdoor = Objects.requireNonNull(backdoor);
    }

    @Override
    public void assertLastChangeHistoryRecords(String issueKey, ExpectedChangeHistoryRecord expectedChangeHistoryRecord) {
        if (expectedChangeHistoryRecord != null) {
            this.assertLastChangeHistoryRecords(issueKey, Collections.singletonList(expectedChangeHistoryRecord));
        } else {
            this.assertLastChangeHistoryRecords(issueKey, (List)null);
        }
    }

    @Override
    public void assertNewestChangeHistoryRecord(String issueKey, String authorName, List<ExpectedChangeHistoryItem> expectedChangeHistoryItems) {
        ChangeHistorySet topHistoryListRecord = (ChangeHistorySet)this.parser.issue().parseChangeHistory().get(0);
        ChangeLog.History firstHistoryEntry = (ChangeLog.History)this.backdoor.issues().getIssue((String)issueKey, (Issue.Expand[])new Issue.Expand[]{Issue.Expand.changelog}).changelog.getHistories().stream().filter(entry -> Long.toString(entry.getId()).equals(topHistoryListRecord.getId())).collect(Collectors.toList()).get(0);
        org.assertj.core.api.Assertions.assertThat((String)firstHistoryEntry.getAuthor().getName()).isEqualTo(authorName);
        for (ExpectedChangeHistoryItem expected : expectedChangeHistoryItems) {
            String expectedFieldName = expected.getFieldName();
            String expectedOldValue = (String)Iterables.get(expected.getOldValues(), (int)0);
            String expectedNewValue = (String)Iterables.get(expected.getNewValues(), (int)0);
            org.assertj.core.api.Assertions.assertThat((List)firstHistoryEntry.items).anySatisfy(historyItem -> {
                if (!Strings.isNullOrEmpty((String)historyItem.field)) {
                    org.assertj.core.api.Assertions.assertThat((String)historyItem.field).isEqualTo(expectedFieldName);
                }
                if (!Strings.isNullOrEmpty((String)historyItem.fromString)) {
                    org.assertj.core.api.Assertions.assertThat((String)historyItem.fromString).isEqualTo(expectedOldValue);
                }
                if (!Strings.isNullOrEmpty((String)historyItem.toString)) {
                    org.assertj.core.api.Assertions.assertThat((String)historyItem.toString).isEqualTo(expectedNewValue);
                }
            });
        }
    }

    @Override
    public CommentAssertions comments(Iterable<String> comments) {
        return new DefaultCommentAssertions(comments, this.navigation, this.getTextAssertions(), this.locator);
    }

    @Override
    public CommentAssertions comments(String ... comments) {
        return new DefaultCommentAssertions(Arrays.asList(comments), this.navigation, this.getTextAssertions(), this.locator);
    }

    @Override
    public void assertLastChangeHistoryRecords(String issueKey, List expectedChangeHistoryRecords) {
        Object[] changeHistoryTables;
        this.navigation.issue().gotoIssueChangeHistory(issueKey);
        try {
            changeHistoryTables = this.tester.getDialog().getResponse().getMatchingTables((htmlElement, criteria) -> {
                HTMLElement element = (HTMLElement)htmlElement;
                String id = element.getID();
                return id != null && id.startsWith((String)criteria);
            }, (Object)"changehistory_");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        if (expectedChangeHistoryRecords != null && !expectedChangeHistoryRecords.isEmpty()) {
            int l = changeHistoryTables.length - 1;
            for (int i = expectedChangeHistoryRecords.size() - 1; i >= 0; --i) {
                ExpectedChangeHistoryRecord expectedChangeHistoryRecord = (ExpectedChangeHistoryRecord)expectedChangeHistoryRecords.get(i);
                Object lastChangeHistoryTable = changeHistoryTables[l];
                ArrayList<ExpectedChangeHistoryItem> expectedChangeItems = new ArrayList<ExpectedChangeHistoryItem>(expectedChangeHistoryRecord.getChangeItems());
                Collections.reverse(expectedChangeItems);
                int j = lastChangeHistoryTable.getRowCount() - 1;
                for (int k = 0; k < expectedChangeItems.size(); ++k) {
                    String fieldName = lastChangeHistoryTable.getCellAsText(j, 0).trim();
                    String oldValue = lastChangeHistoryTable.getCellAsText(j, 1).trim();
                    String newValue = lastChangeHistoryTable.getCellAsText(j, 2).trim();
                    ((AbstractBooleanAssert)org.assertj.core.api.Assertions.assertThat((boolean)this.isChangeItemPresent(fieldName, oldValue, newValue, expectedChangeItems)).overridingErrorMessage(String.format("change item not present: fieldName: %s, oldValue: %s, newValue: %s, expectedChangeItems: %s", fieldName, oldValue, newValue, expectedChangeItems), new Object[0])).isTrue();
                    --j;
                }
                String message = "Change history record appears to have extra change items";
                ((AbstractBooleanAssert)org.assertj.core.api.Assertions.assertThat((j == -1 || j == 0 ? 1 : 0) != 0).overridingErrorMessage("Change history record appears to have extra change items", new Object[0])).isTrue();
                --l;
            }
        } else {
            ((ObjectArrayAssert)org.assertj.core.api.Assertions.assertThat((Object[])changeHistoryTables).overridingErrorMessage("The issue '" + issueKey + "' has change history records", new Object[0])).isNull();
        }
    }

    @Override
    public HTMLAssertions html() {
        if (this.htmlAssertions == null) {
            this.htmlAssertions = new HTMLAssertionsImpl();
        }
        return this.htmlAssertions;
    }

    @Override
    public TextAssertions text() {
        return this.getTextAssertions();
    }

    @Override
    public LinkAssertions link() {
        return this.getLinkAssertions();
    }

    @Override
    public JiraFormAssertions forms() {
        return this.getJiraFormAssertions();
    }

    @Override
    public PluginAssertions plugins() {
        if (this.pluginAssertions == null) {
            this.pluginAssertions = new PluginAssertionsImpl(this.backdoor.plugins());
        }
        return this.pluginAssertions;
    }

    @Override
    public IssueNavigatorAssertions getIssueNavigatorAssertions() {
        if (this.issueNavigatorAssertions == null) {
            this.issueNavigatorAssertions = new IssueNavigatorAssertionsImpl(this.tester, this.environmentData);
        }
        return this.issueNavigatorAssertions;
    }

    @Override
    public ViewIssueAssertions getViewIssueAssertions() {
        if (this.viewIssueAssertions == null) {
            this.viewIssueAssertions = new ViewIssueAssertions(this.tester, this, this.environmentData);
        }
        return this.viewIssueAssertions;
    }

    @Override
    public DashboardAssertions getDashboardAssertions() {
        if (this.dashboardAssertions == null) {
            this.dashboardAssertions = new DashboardAssertionsImpl(this.tester, this.environmentData, this.getURLAssertions());
        }
        return this.dashboardAssertions;
    }

    @Override
    public JiraFormAssertions getJiraFormAssertions() {
        if (this.jiraFormAssertions == null) {
            this.jiraFormAssertions = new JiraFormAssertionsImpl(this.getTextAssertions(), this.tester, this.environmentData);
        }
        return this.jiraFormAssertions;
    }

    @Override
    public JiraMessageAssertions getJiraMessageAssertions() {
        if (this.jiraMessageAssertions == null) {
            this.jiraMessageAssertions = new JiraMessageAssertionsImpl(this.tester, this.environmentData, this.locator, this.getTextAssertions());
        }
        return this.jiraMessageAssertions;
    }

    @Override
    public ProjectFieldsAssertions getProjectFieldsAssertions() {
        if (this.projectFieldsAssertions == null) {
            this.projectFieldsAssertions = new ProjectFieldsAssertionsImpl(this.tester, this.environmentData);
        }
        return this.projectFieldsAssertions;
    }

    @Override
    public URLAssertions getURLAssertions() {
        if (this.urlAssertions == null) {
            this.urlAssertions = new URLAssertionsImpl(this.tester, this.environmentData);
        }
        return this.urlAssertions;
    }

    @Override
    public TextAssertions getTextAssertions() {
        if (this.textAssertions == null) {
            this.textAssertions = new TextAssertionsImpl(this.tester);
        }
        return this.textAssertions;
    }

    @Override
    public LinkAssertions getLinkAssertions() {
        if (this.linkAssertions == null) {
            this.linkAssertions = new LinkAssertionsImpl(this.tester, this.environmentData);
        }
        return this.linkAssertions;
    }

    @Override
    public LabelAssertions getLabelAssertions() {
        if (this.labelAssertions == null) {
            this.labelAssertions = new LabelAssertionsImpl(this.tester, this.environmentData);
        }
        return this.labelAssertions;
    }

    @Override
    public TableAssertions getTableAssertions() {
        if (this.tableAssertions == null) {
            this.tableAssertions = new TableAssertions(this.tester, this.environmentData);
        }
        return this.tableAssertions;
    }

    @Override
    public UserAssertions getUserAssertions() {
        if (this.userAssertions == null) {
            this.userAssertions = new UserAssertions(this.tester, this.environmentData, this);
        }
        return this.userAssertions;
    }

    @Override
    public RequestAssertions getRequestAssertions() {
        if (this.requestAssertions == null) {
            this.requestAssertions = new RequestAssertions(this.tester, this.environmentData);
        }
        return this.requestAssertions;
    }

    @Override
    public SidebarAssertions getSidebarAssertions() {
        if (this.sidebarAssertions == null) {
            this.sidebarAssertions = new SidebarAssertionsImpl(this.locator, this.tester, this.environmentData);
        }
        return this.sidebarAssertions;
    }

    private boolean isChangeItemPresent(String fieldName, String oldValue, String newValue, List<ExpectedChangeHistoryItem> expectedChangeItems) {
        for (ExpectedChangeHistoryItem item : expectedChangeItems) {
            if (!item.getFieldName().equals(fieldName) || !this.equalsChangeHistoryValues(item.getOldValues(), oldValue) || !this.equalsChangeHistoryValues(item.getNewValues(), newValue)) continue;
            return true;
        }
        return false;
    }

    private boolean equalsChangeHistoryValues(Collection<String> expectedValues, String actualValue) {
        return expectedValues == null || expectedValues.isEmpty() ? StringUtils.isBlank((CharSequence)actualValue) : expectedValues.stream().filter(StringUtils::isNotBlank).allMatch(actualValue::contains);
    }

    @Override
    public void assertEquals(String failureMessage, List expected, List actual) {
        if (!expected.equals(actual)) {
            if (expected.isEmpty() || actual.isEmpty()) {
                org.assertj.core.api.Assertions.assertThat((List)actual).overridingErrorMessage(failureMessage, new Object[0]).isEqualTo((Object)expected);
            }
            for (int i = 0; i < expected.size(); ++i) {
                boolean lastExpected;
                if (i >= actual.size()) {
                    org.assertj.core.api.Assertions.assertThat((List)actual).overridingErrorMessage(failureMessage + " expected more items.", new Object[0]).isEqualTo((Object)expected);
                }
                if (!expected.get(i).equals(actual.get(i))) {
                    String mesg = failureMessage + " item " + i + " not equal";
                    org.assertj.core.api.Assertions.assertThat((List)actual).overridingErrorMessage(mesg, new Object[0]).isEqualTo((Object)expected);
                }
                boolean bl = lastExpected = i == expected.size() - 1;
                if (!lastExpected || actual.size() <= expected.size()) continue;
                org.assertj.core.api.Assertions.assertThat((List)actual).overridingErrorMessage(failureMessage + " extra elements in actual (expected list is a prefix).", new Object[0]).isEqualTo((Object)expected);
            }
        }
    }

    @Override
    public void assertProfileLinkPresent(String id, String linkText) {
        try {
            String returnUrl = this.navigation.getCurrentPage();
            WebLink link = this.tester.getDialog().getResponse().getLinkWithID(id);
            ((ObjectAssert)org.assertj.core.api.Assertions.assertThat((Object)link).overridingErrorMessage("No link with id '" + id + "' present.", new Object[0])).isNotNull();
            ((AbstractStringAssert)org.assertj.core.api.Assertions.assertThat((String)link.asText()).overridingErrorMessage("Link text for link with id '" + id + "' does not match '" + linkText + "'.", new Object[0])).isEqualTo(linkText);
            this.tester.clickLink(id);
            this.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), "Username", linkText);
            this.tester.gotoPage(returnUrl);
        }
        catch (SAXException e) {
            Fail.fail((String)("Exception checking for link '" + id + "': " + e));
        }
    }

    @Override
    public void assertNodeByIdExists(String id) {
        IdLocator locator = new IdLocator(this.tester, id);
        this.assertNodeExists(locator);
    }

    @Override
    public void assertNodeByIdDoesNotExist(String id) {
        IdLocator locator = new IdLocator(this.tester, id);
        this.assertNodeDoesNotExist(locator);
    }

    @Override
    public void assertNodeByIdEquals(String id, String textToTest) {
        IdLocator locator = new IdLocator(this.tester, id);
        this.assertNodeEquals(locator, textToTest);
    }

    @Override
    public void assertNodeByIdHasText(String id, String textToTest) {
        IdLocator locator = new IdLocator(this.tester, id);
        this.assertNodeHasText(locator, textToTest);
    }

    @Override
    public void assertNodeByIdDoesNotHaveText(String id, String textToTest) {
        IdLocator locator = new IdLocator(this.tester, id);
        this.assertNodeDoesNotHaveText(locator, textToTest);
    }

    @Override
    public void assertNodeExists(String xpath) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        this.assertNodeExists(locator);
    }

    @Override
    public void assertNodeDoesNotExist(String xpath) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        this.assertNodeDoesNotExist(locator);
    }

    @Override
    public void assertNodeHasText(String xpath, String textToTest) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        this.assertNodeHasText(locator, textToTest);
    }

    @Override
    public void assertNodeDoesNotHaveText(String xpath, String textToTest) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        this.assertNodeDoesNotHaveText(locator, textToTest);
    }

    @Override
    public void assertNodeExists(Locator locator) {
        ((ObjectArrayAssert)org.assertj.core.api.Assertions.assertThat((Object[])locator.getNodes()).overridingErrorMessage("No node found for locator <" + locator + ">", new Object[0])).isNotEmpty();
    }

    @Override
    public void assertNodeDoesNotExist(Locator locator) {
        ((ObjectArrayAssert)org.assertj.core.api.Assertions.assertThat((Object[])locator.getNodes()).overridingErrorMessage("Unexpected node found for locator <" + locator + ">", new Object[0])).isEmpty();
    }

    @Override
    public void assertNodeEquals(Locator locator, String textToTest) {
        this.assertNodeExists(locator);
        org.assertj.core.api.Assertions.assertThat((String)locator.getText()).isEqualTo(textToTest);
    }

    @Override
    public void assertNodeHasText(Locator locator, String textToTest) {
        this.assertNodeExists(locator);
        this.getTextAssertions().assertTextPresent(locator, textToTest);
    }

    @Override
    public void assertNodeDoesNotHaveText(Locator locator, String textToTest) {
        this.assertNodeExists(locator);
        this.getTextAssertions().assertTextNotPresent(locator, textToTest);
    }

    @Override
    public void assertSubmitButtonPresentWithText(String buttonId, String buttonText) {
        ((AbstractBooleanAssert)org.assertj.core.api.Assertions.assertThat((boolean)new XPathLocator(this.tester, "//button[@id='" + buttonId + "' and @value='" + buttonText + "']").exists()).overridingErrorMessage("Button with id '" + buttonId + "' and text '" + buttonText + "' not found!", new Object[0])).isTrue();
    }

    @Override
    public void assertHttpStatusCode(HttpStatus code) {
        ((AbstractIntegerAssert)org.assertj.core.api.Assertions.assertThat((int)this.tester.getDialog().getResponse().getResponseCode()).overridingErrorMessage("Unexpected response code. Expected " + code.code + ", Actual: " + this.tester.getDialog().getResponse().getResponseCode(), new Object[0])).isEqualTo(code.code);
    }
}

