/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.assertions.DashboardAssertions;
import com.atlassian.jira.functest.framework.assertions.URLAssertions;
import com.atlassian.jira.functest.framework.dashboard.DashboardPageInfo;
import com.atlassian.jira.functest.framework.dashboard.DashboardPagePortletInfo;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ObjectAssert;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DashboardAssertionsImpl
implements DashboardAssertions {
    private static final Pattern PATTERN_FAVCOUNT = Pattern.compile("(\\d+)\\s+\\d+");
    private final HtmlPage page;
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final URLAssertions urlAssertions;
    private Navigation navigation;

    @Inject
    public DashboardAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData, URLAssertions urlAssertions) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.urlAssertions = urlAssertions;
        this.page = new HtmlPage(tester);
    }

    @Override
    public void assertDashboardPortlets(Long id, DashboardPagePortletInfo dashboardPortletInfo) {
        this.getNavigation().dashboard().navigateToFullConfigure(id);
        this.assertPortletsOnCurrentPage(dashboardPortletInfo);
    }

    @Override
    public void assertDefaultDashboardPortlets(DashboardPagePortletInfo dashboardPortletInfo) {
        this.getNavigation().dashboard().navigateToDefaultFullConfigure();
        this.assertPortletsOnCurrentPage(dashboardPortletInfo);
    }

    private void assertPortletsOnCurrentPage(DashboardPagePortletInfo dashboardPortletInfo) {
        this.tester.setWorkingForm("jiraform");
        List leftOptions = EasyList.build((Object[])this.tester.getDialog().getOptionsFor("selectedLeftPortlets"));
        Assertions.assertThat((List)leftOptions).overridingErrorMessage("Portlets on left did not match.", new Object[0]).isEqualTo((Object)dashboardPortletInfo.getLeftPortlets());
        List rightOptions = EasyList.build((Object[])this.tester.getDialog().getOptionsFor("selectedRightPortlets"));
        Assertions.assertThat((List)rightOptions).overridingErrorMessage("Portlets on right did not match.", new Object[0]).isEqualTo((Object)dashboardPortletInfo.getRightPortlets());
    }

    @Override
    public void assertColumns(List<String> colHeaders, Locator dashboardsLocator) {
        Assertions.assertThat(this.getColumnHeaders(dashboardsLocator)).isEqualTo(colHeaders);
    }

    @Override
    public void assertDashboardPages(List<? extends SharedEntityInfo> pages, Dashboard.Table table) {
        WebTable webTable;
        try {
            webTable = this.tester.getDialog().getResponse().getTableWithID(table.getTableId());
        }
        catch (SAXException e) {
            Fail.fail((String)("Unable to locate table '" + table + "'."));
            return;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)(webTable.getRowCount() - 1)).overridingErrorMessage("Dashboard incorrect number of pages in table '" + table + "'.", new Object[0])).isEqualTo(pages.size());
        int columns = webTable.getColumnCount();
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        for (int i = 0; i < columns; ++i) {
            String text = webTable.getCellAsText(0, i);
            if (text == null) continue;
            columnMap.put(text.trim(), i);
        }
        XPathLocator locator = new XPathLocator(this.tester, table.toXPath() + "/tbody/tr");
        Node[] nodes = locator.getNodes();
        int row = 1;
        for (SharedEntityInfo sharedEntityInfo : pages) {
            DashboardPageInfo dashboardPageInfo;
            if (sharedEntityInfo.getId() != null) {
                this.checkId(sharedEntityInfo, nodes[row - 1], row);
            }
            if (StringUtils.isNotEmpty((CharSequence)sharedEntityInfo.getName())) {
                DashboardAssertionsImpl.checkNameColumn(sharedEntityInfo, webTable, row, DashboardAssertionsImpl.getColumnNumber("Name", columnMap));
            }
            if (StringUtils.isNotEmpty((CharSequence)sharedEntityInfo.getOwner())) {
                this.checkAuthorColumn(sharedEntityInfo, webTable, row, DashboardAssertionsImpl.getColumnNumber("Owner", columnMap));
            }
            if (sharedEntityInfo.getSharingPermissions() != null) {
                this.checkShares(sharedEntityInfo, webTable, row, DashboardAssertionsImpl.getColumnNumber("Shared with", columnMap));
            }
            if (sharedEntityInfo.getFavCount() != null) {
                this.checkFavouriteCount(sharedEntityInfo, webTable, row, DashboardAssertionsImpl.getColumnNumber("Popularity", columnMap));
            }
            if (sharedEntityInfo instanceof DashboardPageInfo && (dashboardPageInfo = (DashboardPageInfo)sharedEntityInfo).getOperations() != null) {
                this.checkOperations(dashboardPageInfo, webTable, row, DashboardAssertionsImpl.getColumnNumber("", columnMap));
            }
            ++row;
        }
    }

    private void checkId(SharedEntityInfo sharedEntityInfo, Node node, int row) {
        long id = sharedEntityInfo.getId();
        Attr idAttribute = (Attr)node.getAttributes().getNamedItem("id");
        ((ObjectAssert)Assertions.assertThat((Object)idAttribute).overridingErrorMessage("Expected page with id '" + id + "' in row '" + row + "'.", new Object[0])).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)idAttribute.getValue()).overridingErrorMessage("Expected page with id '" + id + "' in row '" + row + "'.", new Object[0])).isEqualTo("pp_" + id);
    }

    private void checkOperations(DashboardPageInfo dashboardPageInfo, WebTable webTable, int row, int column) {
        TableCell cell = webTable.getTableCell(row, column);
        for (DashboardPageInfo.Operation operation : DashboardPageInfo.Operation.ALL) {
            WebLink webLink;
            if (dashboardPageInfo.getOperations().contains(operation)) {
                webLink = cell.getLinkWith(operation.getLinkName());
                ((ObjectAssert)Assertions.assertThat((Object)webLink).overridingErrorMessage("Dasboard at row '" + row + "' does not appear to have operation '" + operation + "'.", new Object[0])).isNotNull();
                String expectedLink = this.page.addXsrfToken(operation.getUrl(dashboardPageInfo.getId()));
                this.urlAssertions.assertURLAreSimilair("Operation '" + operation + "' for dashboard at row '" + row + "' does not link to '" + expectedLink + "' (got link '" + webLink.getURLString() + "').", expectedLink, webLink.getURLString());
                continue;
            }
            webLink = cell.getLinkWith(operation.getLinkName());
            ((ObjectAssert)Assertions.assertThat((Object)webLink).overridingErrorMessage("Dasboard at row '" + row + "' does appears to have operation '" + operation + "'.", new Object[0])).isNull();
        }
    }

    private void checkFavouriteCount(SharedEntityInfo dashboardPageInfo, WebTable webTable, int row, int column) {
        String text = webTable.getCellAsText(row, column).trim();
        Matcher matcher = PATTERN_FAVCOUNT.matcher(text);
        if (matcher.find()) {
            try {
                int count = Integer.parseInt(matcher.group(1));
                ((AbstractIntegerAssert)Assertions.assertThat((int)count).overridingErrorMessage("Dashboard at row " + row + " does not appear to have a favourite count of " + dashboardPageInfo.getFavCount() + ".", new Object[0])).isEqualTo(dashboardPageInfo.getFavCount().intValue());
            }
            catch (NumberFormatException e) {
                Fail.fail((String)("Dashboard at row " + row + " does not appear to have a favourite count of " + dashboardPageInfo.getFavCount() + "."));
            }
        } else {
            Fail.fail((String)("Dashboard at row " + row + " does not appear to have a favourite count of " + dashboardPageInfo.getFavCount() + "."));
        }
    }

    private void checkShares(SharedEntityInfo dashboardPageInfo, WebTable webTable, int row, int column) {
        String text = webTable.getCellAsText(row, column).trim();
        Set<? extends TestSharingPermission> permissions = dashboardPageInfo.getSharingPermissions();
        if (permissions.isEmpty()) {
            ((AbstractStringAssert)Assertions.assertThat((String)text).overridingErrorMessage("Dashboard at row " + row + " does not appear to be shared privately.", new Object[0])).contains(new CharSequence[]{"Private"});
        } else {
            for (TestSharingPermission testSharingPermission : permissions) {
                ((AbstractBooleanAssert)Assertions.assertThat((text.indexOf(testSharingPermission.toDisplayFormat()) >= 0 ^ text.indexOf(testSharingPermission.toDisplayFormatUnknown()) >= 0 || text.indexOf(testSharingPermission.toDisplayFormat()) >= 0 && text.indexOf(testSharingPermission.toDisplayFormatUnknown()) >= 0 ? 1 : 0) != 0).overridingErrorMessage("Dashboard at row " + row + " does not appear to shared as '" + testSharingPermission.toDisplayFormat() + "' or as '" + testSharingPermission.toDisplayFormatUnknown() + "'.", new Object[0])).isTrue();
            }
        }
    }

    private void checkAuthorColumn(SharedEntityInfo dashboardPageInfo, WebTable webTable, int row, int column) {
        String text = webTable.getCellAsText(row, column).trim();
        ((AbstractStringAssert)Assertions.assertThat((String)text).overridingErrorMessage("Dashboard at row " + row + " does not appear to owned by '" + dashboardPageInfo.getOwner() + "'.", new Object[0])).contains(new CharSequence[]{dashboardPageInfo.getOwner()});
    }

    private static void checkNameColumn(SharedEntityInfo dashboardPageInfo, WebTable webTable, int row, int column) {
        String text = webTable.getCellAsText(row, column).trim();
        ((AbstractStringAssert)Assertions.assertThat((String)text).overridingErrorMessage("Dashboard at row " + row + " does not appear to be called '" + dashboardPageInfo.getName() + "'.", new Object[0])).contains(new CharSequence[]{dashboardPageInfo.getName()});
        TableCell tableCell = webTable.getTableCell(row, column);
        if (dashboardPageInfo.isFavourite()) {
            ((AbstractStringAssert)Assertions.assertThat((String)tableCell.getLinks()[0].getTitle()).overridingErrorMessage("Dashboard at row " + row + " does not appear to be a favourite'.", new Object[0])).contains(new CharSequence[]{"Remove this dashboard from your favourites"});
        } else {
            ((AbstractStringAssert)Assertions.assertThat((String)tableCell.getLinks()[0].getTitle()).overridingErrorMessage("Dashboard at row " + row + " appears to be a favourite'.", new Object[0])).contains(new CharSequence[]{"Add this dashboard to your favourites"});
        }
        if (StringUtils.isNotEmpty((CharSequence)dashboardPageInfo.getDescription())) {
            ((AbstractStringAssert)Assertions.assertThat((String)text).overridingErrorMessage("Dashboard at row " + row + " does not have description '" + dashboardPageInfo.getDescription() + "'.", new Object[0])).contains(new CharSequence[]{dashboardPageInfo.getDescription()});
        }
    }

    private static int getColumnNumber(String columnName, Map<String, Integer> columnMap) {
        Integer column = columnMap.get(columnName);
        if (column == null) {
            Fail.fail((String)("Dashboard table does not appear to have a '" + columnName + "' column."));
        }
        return column;
    }

    private List<String> getColumnHeaders(Locator dashboardsLocator) {
        Node[] colHeaders = this.getHeaderColumnsLocator(dashboardsLocator).getNodes();
        ArrayList<String> results = new ArrayList<String>(colHeaders.length);
        for (Node colHeader : colHeaders) {
            String o = DomKit.getCollapsedText(colHeader);
            results.add(o != null ? o.trim() : null);
        }
        return results;
    }

    private Locator getHeaderColumnsLocator(Locator dashboardsLocator) {
        XPathLocator rowLocator = new XPathLocator(dashboardsLocator.getNode(), "thead/tr[1]");
        Node row = rowLocator.getNode();
        return new XPathLocator(row, "th");
    }

    private Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        return this.navigation;
    }
}

