/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class ColumnControl
extends BackdoorControl<ColumnControl> {
    public ColumnControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<ColumnItem> getLoggedInUserColumns() {
        return this.getUserColumns(null);
    }

    public boolean setLoggedInUserColumns(List<String> columnIds) {
        return this.setUserColumns(null, columnIds);
    }

    public boolean addLoggedInUserColumns(List<String> columnIds) {
        return this.addUserColumns(null, columnIds);
    }

    public boolean restoreLoggedInUserColumns() {
        return this.restoreUserColumns(null);
    }

    public List<ColumnItem> getUserColumns(String username) {
        WebTarget resource = this.createResource().path("user/columns");
        if (username != null) {
            resource = resource.queryParam("username", new Object[]{username});
        }
        return (List)resource.request().get((GenericType)new GenericType<List<ColumnItem>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUserColumns(String username, List<String> columnIds) {
        WebTarget resource = this.createResource().path("user/columns");
        MultivaluedHashMap formData = new MultivaluedHashMap();
        if (username != null) {
            formData.add((Object)"username", (Object)username);
        }
        for (String id : columnIds) {
            formData.add((Object)"columns", (Object)id);
        }
        try (Response result = (Response)resource.request().put(Entity.form((MultivaluedMap)formData), Response.class);){
            boolean bl = result.getStatusInfo() == Response.Status.OK;
            return bl;
        }
    }

    public boolean addUserColumns(String username, List<String> columnIds) {
        return this.setUserColumns(username, this.addColumns(this.getUserColumns(username), columnIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restoreUserColumns(String username) {
        WebTarget resource = this.createResource().path("user/columns");
        if (username != null) {
            resource = resource.queryParam("username", new Object[]{username});
        }
        try (Response result = (Response)resource.request().delete(Response.class);){
            boolean bl = result.getStatusInfo() == Response.Status.OK;
            return bl;
        }
    }

    public List<ColumnItem> getFilterColumns(String filterId) {
        WebTarget resource = this.createResource().path("filter/" + filterId + "/columns");
        return (List)resource.request().get((GenericType)new GenericType<List<ColumnItem>>(){});
    }

    public boolean setFilterColumns(String filterId, List<String> columnIds) {
        WebTarget resource = this.createResource().path("filter/" + filterId + "/columns");
        Form formData = new Form();
        for (String id : columnIds) {
            formData.param("columns", id);
        }
        try (Response result = (Response)resource.request().put(Entity.form((Form)formData), Response.class);){
            boolean bl = result.getStatusInfo() == Response.Status.OK;
            return bl;
        }
    }

    public List<ColumnItem> getSystemDefaultColumns() {
        WebTarget resource = this.createResource().path("settings/columns");
        return (List)resource.request().get((GenericType)new GenericType<List<ColumnItem>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSystemDefaultColumns(List<String> columnIds) {
        WebTarget resource = this.createResource().path("settings/columns");
        Form formData = new Form();
        for (String id : columnIds) {
            formData.param("columns", id);
        }
        try (Response result = (Response)resource.request().put(Entity.form((Form)formData), Response.class);){
            boolean bl = result.getStatusInfo() == Response.Status.OK;
            return bl;
        }
    }

    private List<String> addColumns(List<ColumnItem> originalColumns, List<String> newColumns) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnItem originalColumn : originalColumns) {
            builder.add((Object)originalColumn.value);
        }
        builder.addAll(newColumns);
        return builder.build();
    }

    @Override
    protected WebTarget createResource() {
        return this.resourceRoot(this.rootPath).path("rest").path("api").path("2");
    }

    @XmlRootElement
    public static class ColumnItem {
        @XmlElement
        public String label;
        @XmlElement
        public String value;

        public ColumnItem(String value, String label) {
            this.label = label;
            this.value = value;
        }

        ColumnItem() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnItem that = (ColumnItem)o;
            return Objects.equals(this.label, that.label) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.value);
        }

        public String toString() {
            return "ColumnItem{label='" + this.label + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }
}

