/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Map;

public class DbrStatsControl
extends BackdoorControl<DbrStatsControl> {
    public static final String ROOT_PATH = "/indexReplicationStats";

    public DbrStatsControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public SenderStatsWrapper getDbrSenderTotalStats() {
        Map stats = (Map)this.createResource().path("/indexReplicationStats/dbrSenderTotal").request().get(Map.class);
        return new SenderStatsWrapper(stats);
    }

    public ReceiverStatsWrapper getDbrReceiverTotalStats() {
        Map stats = (Map)this.createResource().path("/indexReplicationStats/dbrReceiverTotal").request().get(Map.class);
        return new ReceiverStatsWrapper(stats);
    }

    public ReindexStatsWrapper getReindexTotalStats() {
        JsonObject jsonObject = new Gson().toJsonTree(this.createResource().path("/indexReplicationStats/reindexStatsTotal").request().get(Map.class)).getAsJsonObject();
        return new ReindexStatsWrapper(jsonObject);
    }

    public class ReindexStatsWrapper {
        private final long filterOutAlreadyIndexedBeforeCounter;
        private final long filterOutAlreadyIndexedAfterCounter;

        public ReindexStatsWrapper(JsonObject jsonObject) {
            this.filterOutAlreadyIndexedBeforeCounter = this.getStats(jsonObject, "filterOutAlreadyIndexedBeforeCounter");
            this.filterOutAlreadyIndexedAfterCounter = this.getStats(jsonObject, "filterOutAlreadyIndexedAfterCounter");
        }

        private long getStats(JsonObject jsonObject, String property) {
            if (!jsonObject.has(property)) {
                return 0L;
            }
            JsonObject propertyValue = jsonObject.getAsJsonObject(property);
            return propertyValue.getAsJsonObject("ISSUE").get("sum").getAsLong();
        }

        public long getFilterOutAlreadyIndexedBeforeCounter() {
            return this.filterOutAlreadyIndexedBeforeCounter;
        }

        public long getFilterOutAlreadyIndexedAfterCounter() {
            return this.filterOutAlreadyIndexedAfterCounter;
        }
    }

    public class SenderStatsWrapper {
        private final long createDBRMessageUpdateWithRelatedIssueIndexCount;
        private final long createDBRMessageUpdateWithRelatedIssueIndexSum;

        public SenderStatsWrapper(Map senderStats) {
            String[] stats = senderStats.get("createDBRMessageUpdateWithRelatedIssueIndex").toString().split(", ");
            this.createDBRMessageUpdateWithRelatedIssueIndexCount = (long)Double.parseDouble(stats[0].split("=")[1]);
            this.createDBRMessageUpdateWithRelatedIssueIndexSum = (long)Double.parseDouble(stats[0].split("=")[1]);
        }

        public long getCreateDBRMessageUpdateWithRelatedIssueIndexCount() {
            return this.createDBRMessageUpdateWithRelatedIssueIndexCount;
        }

        public long getCreateDBRMessageUpdateWithRelatedIssueIndexSum() {
            return this.createDBRMessageUpdateWithRelatedIssueIndexSum;
        }
    }

    public class ReceiverStatsWrapper {
        private final long receiveDBRMessage;
        private final long receiveDBRMessageUpdateWithRelated;
        private final long processDBRMessageUpdateWithRelatedIssueIndexSum;

        public ReceiverStatsWrapper(Map receiverStats) {
            this.receiveDBRMessage = (long)Double.parseDouble(receiverStats.get("receiveDBRMessage").toString());
            this.receiveDBRMessageUpdateWithRelated = (long)Double.parseDouble(receiverStats.get("receiveDBRMessageUpdateWithRelated").toString());
            this.processDBRMessageUpdateWithRelatedIssueIndexSum = (long)Double.parseDouble(receiverStats.get("processDBRMessageUpdateWithRelatedIssueIndex").toString().split(", ")[3].split("=")[1]);
        }

        public long getReceiveDBRMessage() {
            return this.receiveDBRMessage;
        }

        public long getReceiveDBRMessageUpdateWithRelated() {
            return this.receiveDBRMessageUpdateWithRelated;
        }

        public long getProcessDBRMessageUpdateWithRelatedIssueIndexSum() {
            return this.processDBRMessageUpdateWithRelatedIssueIndexSum;
        }
    }
}

