/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.VersionClient;
import com.atlassian.jira.testkit.client.restclient.VersionMove;
import java.net.URI;
import javax.annotation.Nullable;

public class VersionControl
extends BackdoorControl<VersionControl> {
    private VersionClient versionClient;

    public VersionControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.versionClient = new VersionClient(environmentData);
    }

    public Version createVersion(String name, String description, String projectKey) {
        Version version = new Version().name(name).description(description).project(projectKey);
        return this.versionClient.create(version);
    }

    public Version releaseVersion(Long versionId) {
        Version version = this.versionClient.get(versionId.toString());
        Version updatedVersion = version.released(Boolean.valueOf(true));
        this.versionClient.putResponse(updatedVersion);
        return updatedVersion;
    }

    public Version unreleaseVersion(Long versionId) {
        Version version = this.versionClient.get(versionId.toString());
        Version updatedVersion = version.released(Boolean.valueOf(false));
        this.versionClient.putResponse(updatedVersion);
        return updatedVersion;
    }

    public void mergeVersion(Long fromVersionId, Long toVersionId2) {
        Version version2 = this.versionClient.get(toVersionId2.toString());
        URI mergeTo = this.uriOrNull(version2.self);
        this.versionClient.delete(fromVersionId.toString(), mergeTo, mergeTo);
    }

    public Version setDescription(Long versionId, String desc) {
        Version version = this.versionClient.get(versionId.toString());
        Version updatedVersion = version.description(desc);
        this.versionClient.putResponse(updatedVersion);
        return updatedVersion;
    }

    public void moveVersion(Long versionId) {
        VersionMove versionMove = new VersionMove();
        versionMove.position("Last");
        this.versionClient.move(versionId.toString(), versionMove);
    }

    public void deleteVersion(Long versionId) {
        this.versionClient.delete(versionId.toString());
    }

    public void delete(Long versionId, @Nullable String fixVersionSwapToSelf, @Nullable String affectsVersionSwapSelf) {
        this.versionClient.delete(String.valueOf(versionId), this.uriOrNull(fixVersionSwapToSelf), this.uriOrNull(affectsVersionSwapSelf));
    }

    private URI uriOrNull(String fixVersionSwapToSelf) {
        return fixVersionSwapToSelf != null ? URI.create(fixVersionSwapToSelf) : null;
    }
}

