/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.WorkflowsControl;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class WorkflowsControlExt
extends WorkflowsControl {
    public WorkflowsControlExt(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<Workflow> getWorkflowsDetailed() {
        return (List)this.createExtTarget().request().get(Workflow.LIST);
    }

    public Workflow getWorkflowDetailed(String name) {
        return this.getWorkflow(name, false);
    }

    public Workflow getWorkflowDraftDetailed(String name) {
        return this.getWorkflow(name, true);
    }

    private Workflow getWorkflow(String name, boolean draft) {
        ParsedResponse response = this.toResponse(() -> (Response)this.createExtTarget().queryParam("name", new Object[]{name}).queryParam("draft", new Object[]{Boolean.toString(draft)}).request().get(Response.class), Workflow.class);
        return (Workflow)response.body;
    }

    public Workflow createWorkflow(String name) {
        return (Workflow)this.createExtTarget().request().post(Entity.json((Object)name), Workflow.class);
    }

    public Workflow createDraftOfWorkflow(String parentName) {
        return (Workflow)this.createExtTarget().path("createdraft").request().post(Entity.json((Object)parentName), Workflow.class);
    }

    public void setDescription(String name, String description) {
        this.createExtTarget().path(name).request().post(Entity.json((Object)description), String.class);
    }

    public void deleteWorkflow(String name) {
        this.createExtTarget().queryParam("name", new Object[]{name}).request().delete();
    }

    public void addMetaAttributeToWorkflowStep(String workflowName, String stepName, String attributeName, String attributeValue) {
        this.createExtTarget().path("addMetaAttributeToWorkflowStep").queryParam("workflow", new Object[]{workflowName}).queryParam("step", new Object[]{stepName}).queryParam("attribute", new Object[]{attributeName}).queryParam("value", new Object[]{attributeValue}).request().get(String.class);
    }

    private WebTarget createExtTarget() {
        return this.createResourceForPath("func-test").path("workflow");
    }

    private WebTarget createRestAPITarget() {
        return this.createResourceForPath("api", "2").path("workflow");
    }

    public void setTransitionProperty(String workflowName, boolean draft, long transitionID, String key, Object value) {
        this.createRestAPITarget().path("transitions").path(String.valueOf(transitionID)).path("properties").queryParam("workflowName", new Object[]{workflowName}).queryParam("key", new Object[]{key}).queryParam("workflowMode", new Object[]{draft ? "draft" : "live"}).request().put(Entity.json((Object)new PropertyBean(key, value.toString())), String.class);
    }

    public Map<String, String> getProperties(String workflowName, boolean draft, long transitionId) {
        List propertyBeans = (List)this.createRestAPITarget().path("transitions").path(String.valueOf(transitionId)).path("properties").queryParam("workflowName", new Object[]{workflowName}).queryParam("workflowMode", new Object[]{draft ? "draft" : "live"}).request().get(PropertyBean.LIST);
        HashMap result = Maps.newHashMap();
        for (PropertyBean property : propertyBeans) {
            result.put(property.getKey(), property.getValue());
        }
        return result;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Workflow {
        private static final GenericType<List<Workflow>> LIST = new GenericType<List<Workflow>>(){};
        @JsonProperty
        private String name;
        @JsonProperty
        private String description;
        @JsonProperty
        private boolean hasDraft;
        @JsonProperty
        private boolean draft;
        @JsonProperty
        private String descriptorXml;

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isHasDraft() {
            return this.hasDraft;
        }

        public void setHasDraft(boolean hasDraft) {
            this.hasDraft = hasDraft;
        }

        public boolean isDraft() {
            return this.draft;
        }

        public void setDraft(boolean draft) {
            this.draft = draft;
        }

        public String getDescriptorXml() {
            return this.descriptorXml;
        }

        public void setDescriptorXml(String descriptorXml) {
            this.descriptorXml = descriptorXml;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PropertyBean {
        private static final GenericType<List<PropertyBean>> LIST = new GenericType<List<PropertyBean>>(){};
        private final String key;
        private final String value;

        @JsonCreator
        public PropertyBean(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) {
            this.key = StringUtils.stripToNull((String)key);
            this.value = StringUtils.stripToEmpty((String)value);
        }

        @JsonProperty
        public String getKey() {
            return this.key;
        }

        @JsonProperty
        public String getValue() {
            return this.value;
        }

        @JsonProperty
        public String getId() {
            return this.getKey();
        }
    }
}

