/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizardImpl;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.page.IssueSearchPage;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebResponse;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Fail;
import org.xml.sax.SAXException;

public class IssueNavigatorNavigationImpl
implements IssueNavigatorNavigation {
    private static final String ID_LINK_SWITCHNAVTYPE = "switchnavtype";
    private static final String ID_LINK_VIEWFILTER = "viewfilter";
    private static final String ID_LINK_NEW_FILTER = "new_filter";
    private static final String ID_FILTER_FORM_HEADER = "filterFormHeader";
    private static final String ID_JQL_FORM = "jqlform";
    private static final String ID_ISSUE_FILTER = "issue-filter";
    private static final String NAME_FILTER_FORM = "issue-filter";
    private static final Pattern CREATE_URL_PATTERN;
    private static final Pattern SAVE_URL_PATTERN;
    private static final String ID_LINK_EDITFILTER = "editfilter";
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final Backdoor backdoor;
    private final FuncTestLogger logger;
    private final IssueSearchPage issueSearchPage;

    @Inject
    public IssueNavigatorNavigationImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        LocatorFactoryImpl locators = new LocatorFactoryImpl(tester);
        this.tester = tester;
        this.environmentData = environmentData;
        this.backdoor = new Backdoor(environmentData);
        this.logger = new FuncTestLoggerImpl(2);
        this.issueSearchPage = new IssueSearchPage(tester, locators);
    }

    @Override
    public void configureColumns() {
        this.displayAllIssues();
        this.tester.gotoPage("");
    }

    @Override
    public IssueNavigatorNavigation.NavigatorMode getCurrentMode() {
        if (!this.isCurrentlyOnNavigator()) {
            return null;
        }
        String selectedTab = StringUtils.trimToNull((String)new XPathLocator(this.tester, "//ul[@id='filterFormHeader']/li[@class='active']").getText());
        if (selectedTab != null) {
            for (IssueNavigatorNavigation.NavigatorMode navigatorMode : IssueNavigatorNavigation.NavigatorMode.values()) {
                if (!navigatorMode.name().equalsIgnoreCase(selectedTab)) continue;
                return navigatorMode;
            }
        }
        HttpUnitDialog dialog = this.tester.getDialog();
        try {
            if (dialog.isLinkPresent(ID_LINK_SWITCHNAVTYPE)) {
                return IssueNavigatorNavigation.NavigatorMode.EDIT;
            }
            if (dialog.getResponse().getFormWithID(ID_JQL_FORM) != null) {
                return IssueNavigatorNavigation.NavigatorMode.EDIT;
            }
            if (dialog.getResponse().getFormWithName("issue-filter") != null) {
                return IssueNavigatorNavigation.NavigatorMode.EDIT;
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public IssueNavigatorNavigation.NavigatorEditMode getCurrentEditMode() {
        WebResponse webResponse = this.tester.getDialog().getResponse();
        IssueNavigatorNavigation.NavigatorMode mode = this.getCurrentMode();
        if (mode == IssueNavigatorNavigation.NavigatorMode.EDIT || mode == IssueNavigatorNavigation.NavigatorMode.NEW) {
            try {
                if (webResponse.getFormWithID(ID_JQL_FORM) != null) {
                    return IssueNavigatorNavigation.NavigatorEditMode.ADVANCED;
                }
                if (webResponse.getFormWithID("issue-filter") != null) {
                    return IssueNavigatorNavigation.NavigatorEditMode.SIMPLE;
                }
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void gotoNavigator() {
        this.visitNavigator("");
    }

    @Override
    public void displayAllIssues() {
        this.visitNavigator("");
    }

    @Override
    public void displayFullContentAllIssues() {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-fullcontent/temp/SearchRequest.html?jqlQuery=&tempMax=1000");
    }

    @Override
    public void displayRssAllIssues() {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
    }

    @Override
    public void displayRssAllComments() {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
    }

    @Override
    public void displayXmlAllIssues() {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
    }

    @Override
    public void bulkEditAllIssues() {
        this.displayAllIssues();
        this.bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
    }

    @Override
    public void displayPrintableAllIssues() {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=&tempMax=1000");
    }

    @Override
    public void sortIssues(String field, String direction) {
        this.visitNavigator("ORDER%20BY%20" + field + "%20" + direction);
    }

    @Override
    public void addColumnToIssueNavigator(String[] fieldNames) {
        this.backdoor.columnControl().addLoggedInUserColumns(this.fieldNamesToFieldIds(fieldNames));
    }

    private List<String> fieldNamesToFieldIds(String[] fieldNames) {
        List customFields = this.backdoor.customFields().getCustomFields();
        ImmutableMap.Builder builderCustomFieldsById = ImmutableMap.builder();
        for (CustomFieldResponse customField : customFields) {
            builderCustomFieldsById.put((Object)customField.name, (Object)customField.id);
        }
        ImmutableMap customFieldsById = builderCustomFieldsById.build();
        ImmutableList.Builder builderFieldIds = ImmutableList.builder();
        for (String fieldName : fieldNames) {
            if (!customFieldsById.containsKey(fieldName)) continue;
            builderFieldIds.add(customFieldsById.get(fieldName));
        }
        return builderFieldIds.build();
    }

    @Override
    public void restoreColumnDefaults() {
        this.backdoor.columnControl().restoreLoggedInUserColumns();
    }

    @Override
    public void runSearch() {
        this.tester.submit("show");
    }

    @Override
    public void expandAllNavigatorSections() {
    }

    @Override
    public void expandNavigatorSection(String sectionId) {
    }

    @Override
    public BulkChangeWizard bulkChange(IssueNavigatorNavigation.BulkChangeOption bulkChangeOption) {
        if (bulkChangeOption == IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES) {
            String issueLimitString = this.backdoor.applicationProperties().getString("jira.bulk.edit.limit.issue.count");
            int issueLimit = issueLimitString.isEmpty() ? 1000 : Integer.parseInt(issueLimitString);
            this.tester.gotoPage("/views/bulkedit/BulkEdit1!default.jspa?reset=true&tempMax=" + issueLimit);
        } else {
            this.tester.gotoPage("/views/bulkedit/BulkEdit1!default.jspa?reset=true");
        }
        return new BulkChangeWizardImpl(this.tester, this.environmentData);
    }

    @Override
    public void loadFilter(long id) {
        this.tester.gotoPage("/issues/?filter=" + id);
    }

    @Override
    public void loadFilterAndAssert(long id) {
        this.tester.gotoPage("/issues/?filter=" + id);
        this.tester.assertTextNotPresent("The selected filter is not available to you, perhaps it has been deleted or had its permissions changed.");
    }

    @Override
    public void gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode editMode) {
        this.gotoNavigator();
        this.switchIntoEditMode(editMode);
    }

    @Override
    public void editFilter(long id) {
        this.tester.gotoPage("/secure/EditFilter!default.jspa?filterId=" + id);
    }

    @Override
    public void createFilter(String jql) {
        this.visitNavigator(jql);
        this.tester.gotoPage("/secure/SaveAsFilter!default.jspa");
    }

    @Override
    public void clickEditModeFlipLink() {
        this.tester.clickLink(ID_LINK_SWITCHNAVTYPE);
    }

    @Override
    public void gotoViewMode() {
        this.gotoNavigator();
    }

    @Override
    public IssueSearchPage runSearch(String jqlQuery) {
        try {
            this.visitNavigator(URLEncoder.encode(jqlQuery, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.issueSearchPage;
    }

    @Override
    public List<String> runSimpleSearch(String jqlQuery) {
        IssueSearchPage issueSearchPage = this.runSearch(jqlQuery);
        if (!issueSearchPage.hasResultsTable()) {
            return Collections.emptyList();
        }
        return issueSearchPage.getResultsIssueKeys();
    }

    @Override
    public IssueSearchPage runPrintableSearch(String jqlQuery) {
        try {
            String url = "sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=" + URLEncoder.encode(jqlQuery, "UTF-8") + "&tempMax=1000";
            this.tester.gotoPage(url);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.issueSearchPage;
    }

    @Override
    public void runXmlSearch(String jqlQuery, String ... fields) {
        try {
            StringBuilder url = new StringBuilder(256).append("sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=").append(URLEncoder.encode(jqlQuery, "UTF-8")).append("&tempMax=1000");
            for (String field : fields) {
                url.append("&field=").append(URLEncoder.encode(field, "UTF-8"));
            }
            this.tester.gotoPage(url.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IssueNavigatorNavigation createSearch(String jqlQuery) {
        this.visitNavigator(jqlQuery);
        return this;
    }

    @Override
    public void createSearch(NavigatorSearch search) {
        this.logger.log((Object)("Creating search: " + search));
        this.gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.editSearch(search);
    }

    @Override
    public void modifySearch(NavigatorSearch search) {
        this.logger.log((Object)("Modifying search to: " + search));
        this.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.editSearch(search);
    }

    @Override
    public long createNewAndSaveAsFilter(SharedEntityInfo info, NavigatorSearch search) {
        this.createSearch(search);
        return this.saveCurrentAsNewFilter(info);
    }

    @Override
    public long saveCurrentAsNewFilter(SharedEntityInfo info) {
        return this.saveCurrentAsNewFilter(info.getName(), info.getDescription(), info.isFavourite(), info.getSharingPermissions());
    }

    @Override
    public long saveCurrentAsNewFilter(String name, String description, boolean favourite, Set<? extends TestSharingPermission> permissions) {
        HttpUnitDialog dialog = this.tester.getDialog();
        if (dialog.isLinkPresent("filtersavenew")) {
            this.tester.clickLink("filtersavenew");
        } else if (dialog.isLinkPresent("filtersaveas")) {
            this.tester.clickLink("filtersaveas");
        } else {
            Fail.fail((String)"Unable to find 'filtersavenew' or 'filtersaveas' link on page to save as new filter.");
        }
        if (favourite && (permissions == null || permissions.isEmpty())) {
            this.tester.setFormElement("filterName", name);
            if (!StringUtils.isBlank((CharSequence)description)) {
                this.tester.setFormElement("filterDescription", description);
            }
            this.tester.submit("saveasfilter_submit");
        } else {
            this.saveUsingPut(name, description, favourite, permissions);
        }
        URL url = dialog.getResponse().getURL();
        if (StringUtils.isBlank((CharSequence)url.getQuery())) {
            Fail.fail((String)"Unable to save filter.");
        } else {
            Matcher matcher = CREATE_URL_PATTERN.matcher(url.getQuery());
            if (matcher.find()) {
                long id = Long.parseLong(matcher.group(1));
                this.logger.log((Object)("Saved new filter (" + id + ")"));
                return id;
            }
            Fail.fail((String)"Unable to save filter.");
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long saveCurrentFilter() {
        HttpUnitDialog dialog = this.tester.getDialog();
        if (dialog.isLinkPresent("filtersave")) {
            this.tester.clickLink("filtersave");
        } else {
            Fail.fail((String)"Unable to find 'filtersave' link on the page to save current filter.");
        }
        this.tester.submit("Save");
        URL url = dialog.getResponse().getURL();
        if (StringUtils.isBlank((CharSequence)url.getQuery())) {
            Fail.fail((String)"Unable to save filter.");
        } else {
            Matcher matcher = SAVE_URL_PATTERN.matcher(url.getQuery());
            if (matcher.find()) {
                long id = Long.parseLong(matcher.group(1));
                this.logger.log((Object)("Saved filter (" + id + ")"));
                return id;
            }
            Fail.fail((String)"Unable to save filter.");
        }
        return Long.MIN_VALUE;
    }

    @Override
    public void deleteFilter(long id) {
        this.tester.gotoPage("secure/DeleteFilter.jspa?filterId=" + id);
    }

    private void saveUsingPut(String name, String description, boolean favourite, Set<? extends TestSharingPermission> permissions) {
        HtmlPage page = new HtmlPage(this.tester);
        this.tester.gotoPage(page.addXsrfToken(this.createSaveUrl(name, description, favourite, permissions)));
    }

    private String createSaveUrl(String name, String description, boolean favourite, Set<? extends TestSharingPermission> permissions) {
        StringBuilder buffer = new StringBuilder("secure/SaveAsFilter.jspa?submit=Save");
        if (!StringUtils.isBlank((CharSequence)name)) {
            buffer.append("&filterName=").append(this.encode(name));
        }
        if (!StringUtils.isBlank((CharSequence)description)) {
            buffer.append("&filterDescription=").append(this.encode(description));
        }
        if (permissions != null) {
            buffer.append("&shareValues=").append(this.encode(TestSharingPermissionUtils.createJsonString(permissions)));
        }
        buffer.append("&favourite=").append(String.valueOf(favourite));
        return buffer.toString();
    }

    private String encode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isCurrentlyOnNavigator() {
        return new IdLocator(this.tester, ID_FILTER_FORM_HEADER).hasNodes();
    }

    private void switchIntoEditMode(IssueNavigatorNavigation.NavigatorEditMode mode) {
    }

    @Override
    public void gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode navigatorEditMode) {
        this.gotoNavigator();
        if (navigatorEditMode != null) {
            this.switchIntoEditMode(navigatorEditMode);
        }
    }

    @Override
    public IssueNavigatorNavigation.NavigatorMode gotoEditOrNewMode(IssueNavigatorNavigation.NavigatorEditMode mode) {
        this.gotoNavigator();
        IssueNavigatorNavigation.NavigatorMode navigatorMode = this.getCurrentMode();
        if (navigatorMode == IssueNavigatorNavigation.NavigatorMode.EDIT || navigatorMode == IssueNavigatorNavigation.NavigatorMode.NEW) {
            this.switchIntoEditMode(mode);
            return navigatorMode;
        }
        if (this.tester.getDialog().isLinkPresent(ID_LINK_EDITFILTER)) {
            this.gotoEditMode(mode);
            return IssueNavigatorNavigation.NavigatorMode.EDIT;
        }
        this.gotoNewMode(mode);
        return IssueNavigatorNavigation.NavigatorMode.NEW;
    }

    @Override
    public void goToConfigureColumns() {
        this.tester.clickLink("configure-cols");
    }

    private void editSearch(NavigatorSearch search) {
    }

    private void visitNavigator(String jqlSearch) {
        this.tester.gotoPage("/issues/?jql=" + jqlSearch);
    }

    static {
        SAVE_URL_PATTERN = CREATE_URL_PATTERN = Pattern.compile("requestId=(\\d+)");
    }
}

