/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigationImpl;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class ManageFiltersNavigation
implements FilterNavigation {
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final HtmlPage page;
    private IssueNavigatorNavigation issueNavigatorNavigation;

    @Inject
    public ManageFiltersNavigation(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.page = new HtmlPage(tester);
        this.issueNavigatorNavigation = null;
    }

    @Override
    public void addFavourite(int id) {
        this.tester.gotoPage(this.page.addXsrfToken("secure/AddFavourite.jspa?entityId=" + id + "&entityType=SearchRequest"));
    }

    @Override
    public void removeFavourite(int id) {
        this.tester.gotoPage(this.page.addXsrfToken("secure/RemoveFavourite.jspa?entityId=" + id + "&entityType=SearchRequest"));
    }

    @Override
    public void goToDefault() {
        this.favouriteFilters();
    }

    @Override
    public void manageSubscriptions(int filterId) {
        this.tester.gotoPage("secure/ViewSubscriptions.jspa?filterId=" + filterId);
    }

    @Override
    public void addSubscription(int filterId) {
        this.tester.gotoPage("/secure/EditSubscription!default.jspa?filterId=" + filterId);
    }

    @Override
    public void favouriteFilters() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=favourites");
    }

    @Override
    public void myFilters() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=my");
    }

    @Override
    public void allFilters() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=search&pressedSearchButton=true&searchName=&searchOwner=&Search=");
    }

    @Override
    public void popularFilters() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=popular");
    }

    @Override
    public void searchFilters() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=search");
    }

    @Override
    public long createFilter(String filterName, String filterDesc) {
        return this.createFilter(filterName, filterDesc, null);
    }

    @Override
    public long createFilter(String filterName, String filterDesc, Set<TestSharingPermission> sharingPermissions) {
        SharedEntityInfo info = new SharedEntityInfo(filterName, filterDesc, true, sharingPermissions);
        NavigatorSearch search = new NavigatorSearch(Collections.emptyList());
        return this.getIssueNavigatorNavigation().createNewAndSaveAsFilter(info, search);
    }

    private IssueNavigatorNavigation getIssueNavigatorNavigation() {
        if (this.issueNavigatorNavigation == null) {
            this.issueNavigatorNavigation = new IssueNavigatorNavigationImpl(this.tester, this.environmentData);
        }
        return this.issueNavigatorNavigation;
    }

    @Override
    public void deleteFilter(int id) {
        this.tester.gotoPage(this.page.addXsrfToken("secure/DeleteFilter.jspa?filterId=" + id + "&returnUrl=ManageFilters.jspa"));
    }

    @Override
    public void findFilters(String filterName) {
        this.tester.getDialog().setFormParameter("searchName", filterName);
        this.tester.submit("Search");
    }

    @Override
    public List<FilterItem> sanitiseSearchFilterItems(List<FilterItem> expectedItems) {
        return expectedItems;
    }

    @Override
    public List<FilterItem> sanitiseFavouriteFilterItems(List<FilterItem> expectedItems) {
        return expectedItems;
    }

    @Override
    public String getActionBaseUrl() {
        return "ManageFilters.jspa";
    }

    @Override
    public FilterNavigation projects() {
        throw new UnsupportedOperationException("The projects view is unique to the filterpickerpopup implementation");
    }
}

