/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Fail;
import org.xml.sax.SAXException;

public class ColumnsCondition
implements SearchResultsCondition {
    private final Collection<String> columns;

    public ColumnsCondition(Collection<String> columns) {
        this.columns = new ArrayList<String>(columns);
    }

    public ColumnsCondition(String ... columns) {
        this(Arrays.asList(columns));
    }

    @Override
    public void assertCondition(WebTester tester) {
        WebTable table = null;
        try {
            table = tester.getDialog().getResponse().getTableWithID("issuetable");
        }
        catch (SAXException e) {
            Fail.fail((String)("Expected columns '" + this.columns + "' to be visible: Unable to find issue table -" + e.getMessage()));
        }
        if (table == null) {
            if (!this.columns.isEmpty()) {
                Fail.fail((String)("Expected columns '" + this.columns + "' to be visible: Issue table not visible."));
            }
        } else {
            int columnMax = table.getColumnCount();
            int columnPos = 0;
            TableCell lastCell = table.getTableCell(0, columnMax - 1);
            if (!StringUtils.contains((CharSequence)lastCell.getClassName(), (CharSequence)"headerrow-actions")) {
                Fail.fail((String)("Expected actions column to be visible, but was not -- last column is '" + StringUtils.trimToNull((String)lastCell.asText()) + "' (classes '" + lastCell.getClassName() + "')"));
            }
            --columnMax;
            for (String column : this.columns) {
                String content;
                if (columnPos >= columnMax) {
                    Fail.fail((String)("Expected columns '" + this.columns + "' to be visible. Unable to find column '" + column + "."));
                }
                if (!column.equals(content = StringUtils.trimToNull((String)table.getCellAsText(0, columnPos)))) {
                    Fail.fail((String)("Expected columns '" + this.columns + "' to be visible: Found column '" + content + "' instead of '" + column + "'."));
                }
                ++columnPos;
            }
            if (columnPos < columnMax) {
                Fail.fail((String)("Expected columns '" + this.columns + "' to be visible: Found extra column '" + StringUtils.trimToNull((String)table.getCellAsText(0, columnPos)) + "'."));
            }
        }
    }
}

