/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.MultiSelectCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;

public class IssueTypeCondition
extends MultiSelectCondition {
    public IssueTypeCondition() {
        super("type");
    }

    public IssueTypeCondition(IssueTypeCondition copy) {
        super(copy);
    }

    public IssueTypeCondition addIssueType(IssueType type) {
        if (type != null) {
            this.addOption(type.getName());
        }
        return this;
    }

    public boolean removeIssueType(IssueType type) {
        return type != null && this.removeOption(type.getName());
    }

    public IssueTypeCondition addIssueType(String type) {
        this.addOption(type);
        return this;
    }

    public boolean removeIssueType(String type) {
        return this.removeOption(type);
    }

    @Override
    public String toString() {
        return "Issue Types: " + this.getOptions();
    }

    @Override
    public NavigatorCondition copyCondition() {
        return new IssueTypeCondition(this);
    }

    @Override
    public NavigatorCondition copyConditionForParse() {
        return new IssueTypeCondition();
    }

    public static class IssueType {
        public static final IssueType BUG = new IssueType("Bug");
        public static final IssueType IMPROVEMENT = new IssueType("Improvement");
        public static final IssueType NEW_FEATURE = new IssueType("New Feature");
        public static final IssueType TASK = new IssueType("Task");
        private final String name;

        private IssueType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueType issueType = (IssueType)o;
            return this.name.equals(issueType.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

