/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.parser;

import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryParser;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.IssueParser;
import com.atlassian.jira.functest.framework.parser.comment.Comment;
import com.atlassian.jira.functest.framework.parser.comment.CommentParser;
import com.atlassian.jira.functest.framework.parser.issue.ViewIssueDetails;
import com.atlassian.jira.functest.framework.parser.worklog.Worklog;
import com.atlassian.jira.functest.framework.parser.worklog.WorklogParser;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IssueParserImpl
implements IssueParser {
    private final WebTester tester;
    private final WorkflowUtil workflowUtil;

    @Inject
    public IssueParserImpl(WebTester tester, JIRAEnvironmentData environmentData, WorkflowUtil workflowUtil) {
        this.tester = tester;
        this.workflowUtil = workflowUtil;
    }

    @Override
    public ViewIssueDetails parseViewIssuePage() {
        ViewIssueDetails viewIssueDetails = new ViewIssueDetails();
        this.parseIssueDetails(viewIssueDetails);
        viewIssueDetails.setAvailableWorkflowActions(this.workflowUtil.queryAvailableWorkflowActionNames(viewIssueDetails.getKey()));
        viewIssueDetails.setComponents(this.parseComponents());
        viewIssueDetails.setAffectsVersions(this.parseAffectsVersions());
        viewIssueDetails.setFixVersions(this.parseFixVersions());
        viewIssueDetails.setSecurityLevel(this.parseSecurityLevel());
        viewIssueDetails.setProjectName(this.parseProjectName());
        viewIssueDetails.setSummary(this.parseSummary());
        viewIssueDetails.setDueDate(this.parseDueDate());
        viewIssueDetails.setCreatedDate(this.parseCreatedDate());
        viewIssueDetails.setUpdatedDate(this.parseUpdatedDate());
        viewIssueDetails.setResolutionDate(this.parseResolutionDate());
        viewIssueDetails.setOriginalEstimate(this.parseOriginalEstimate());
        viewIssueDetails.setRemainingEstimate(this.parseRemaininglEstimate());
        viewIssueDetails.setTimeSpent(this.parseTimeSpent());
        viewIssueDetails.setAttachments(this.parseFileAttachments());
        viewIssueDetails.setEnvironment(this.parseEnvironment());
        viewIssueDetails.setCustomFields(this.parseCustomFields());
        viewIssueDetails.setDescription(this.parseDescription());
        viewIssueDetails.setLabels(this.parseLabels(viewIssueDetails.getId()));
        return viewIssueDetails;
    }

    private List<String> parseLabels(int issueId) {
        String value = this.getValue("labels-" + issueId + "-value");
        if (value == null) {
            throw new IllegalStateException("no labels node in page for issue " + issueId);
        }
        String[] labelStrings = value.split(" ");
        ArrayList<String> strings = new ArrayList<String>(Arrays.asList(labelStrings));
        strings.remove("Edit");
        strings.remove("Labels");
        return new ArrayList<String>(strings);
    }

    private void parseIssueDetails(ViewIssueDetails viewIssueDetails) {
        viewIssueDetails.setKey(this.getValue("key-val"));
        viewIssueDetails.setId(Integer.parseInt(this.getAttribute("key-val", "rel")));
        viewIssueDetails.setIssueType(this.getValue("type-val"));
        viewIssueDetails.setStatus(this.getValue("status-val"));
        viewIssueDetails.setPriority(this.getValue("priority-val"));
        viewIssueDetails.setResolution(this.getValue("resolution-val"));
        viewIssueDetails.setAssignee(this.getValue("assignee-val"));
        viewIssueDetails.setReporter(this.getValue("reporter-val"));
        viewIssueDetails.setVotes(this.getValue("vote-data"));
        viewIssueDetails.setWatchers(this.getValue("watcher-data"));
    }

    private String getValue(String id) {
        IdLocator locator = new IdLocator(this.tester, id);
        if (locator.getNodes().length > 0) {
            return locator.getText();
        }
        return null;
    }

    private String getAttribute(String id, String attribute) {
        Node attributeNode;
        NamedNodeMap attributes;
        IdLocator locator = new IdLocator(this.tester, id);
        if (locator.getNodes().length > 0 && (attributes = locator.getNodes()[0].getAttributes()) != null && (attributeNode = attributes.getNamedItem(attribute)) != null) {
            return attributeNode.getNodeValue();
        }
        return null;
    }

    private String parseCreatedDate() {
        return this.getValue("created-val");
    }

    private String parseUpdatedDate() {
        return this.getValue("updated-val");
    }

    private String parseEnvironment() {
        String env = this.getValue("environment-val");
        if (StringUtils.isNotBlank((CharSequence)env)) {
            env = env.trim();
        }
        return env;
    }

    private String parseDescription() {
        CssLocator locator = new CssLocator(this.tester, "#descriptionmodule .mod-content");
        if (locator.getNodes().length > 0) {
            return locator.getText();
        }
        return null;
    }

    private Map<String, String> parseCustomFields() {
        HashMap<String, String> customFields = new HashMap<String, String>();
        int tabNum = 1;
        while (new CssLocator(this.tester, "#customfield-panel-" + tabNum + " ul.property-list").getNodes().length != 0) {
            Locator fieldLabels = this.getAllCustomFieldLabels(tabNum);
            Locator fieldValues = this.getAllCustomFieldValues(tabNum);
            Node[] labelNodes = fieldLabels.getNodes();
            Node[] valueNoeds = fieldValues.getNodes();
            for (int i = 0; i < labelNodes.length; ++i) {
                String customFieldName = fieldLabels.getText(labelNodes[i]);
                customFieldName = customFieldName.substring(0, customFieldName.lastIndexOf(":"));
                String customFieldValue = fieldValues.getText(valueNoeds[i]);
                customFields.put(customFieldName, customFieldValue);
            }
            ++tabNum;
        }
        XPathLocator ddLocator = new XPathLocator(this.tester, "//*[@id='datesmodule' or @id='peopledetails']//span[contains(@id, 'customfield')]");
        if (ddLocator.getNodes().length > 0) {
            Node[] valueNodes;
            for (Node valueNode : valueNodes = ddLocator.getNodes()) {
                Node nameNode = valueNode.getAttributes().getNamedItem("data-name");
                if (nameNode == null) continue;
                String name = DomKit.getCollapsedText(nameNode);
                String value = StringUtils.trimToNull((String)DomKit.getCollapsedText(valueNode));
                if (value == null) continue;
                if (name.charAt(name.length() - 1) == ':') {
                    name = name.substring(0, name.length() - 1);
                }
                customFields.put(name, value);
            }
        }
        return customFields;
    }

    private Locator getAllCustomFieldLabels(int tabNum) {
        return new CssLocator(this.tester, "#customfield-panel-" + tabNum + " li.item .name");
    }

    private Locator getAllCustomFieldValues(int tabNum) {
        return new CssLocator(this.tester, "#customfield-panel-" + tabNum + " li.item .value");
    }

    private String findPreviousElementValue(Node node, String elementName) {
        for (Node prev = node.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
            if (prev.getNodeType() != 1 || !elementName.equals(prev.getNodeName())) continue;
            return DomKit.getCollapsedText(prev);
        }
        return null;
    }

    private List<String> parseFileAttachments() {
        ArrayList<String> attachments = new ArrayList<String>();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//*[@id='file_attachments' or @id='attachment_thumbnails']//a[@class='attachment-title' or @data-downloadurl]");
        for (int i = 0; i < xPathLocator.getNodes().length; ++i) {
            Node node = xPathLocator.getNodes()[i];
            attachments.add(node.getTextContent());
        }
        return attachments;
    }

    private String parseOriginalEstimate() {
        return this.getValue("tt_single_values_orig");
    }

    private String parseTimeSpent() {
        return this.getValue("tt_single_values_spent");
    }

    private String parseRemaininglEstimate() {
        return this.getValue("tt_single_values_remain");
    }

    private String parseDueDate() {
        return this.getValue("due-date");
    }

    private String parseResolutionDate() {
        return this.getValue("resolutiondate-val");
    }

    private String parseProjectName() {
        return this.getValue("project-name-val");
    }

    private String parseSummary() {
        CssLocator locator = new CssLocator(this.tester, "header#stalker h2");
        if (locator.getNodes().length > 0) {
            return locator.getText();
        }
        return null;
    }

    private List<String> parseComponents() {
        return this.parseCommaSepValueFromIssueHeader("components-val");
    }

    private List<String> parseAffectsVersions() {
        return this.parseCommaSepValueFromIssueHeader("versions-val");
    }

    private List<String> parseFixVersions() {
        return this.parseCommaSepValueFromIssueHeader("fixfor-val");
    }

    private String parseSecurityLevel() {
        return this.getValue("security-val");
    }

    private List<String> parseCommaSepValueFromIssueHeader(String val) {
        String value = this.getValue(val);
        ArrayList<String> values = new ArrayList<String>();
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                values.add(st.nextToken().trim());
            }
        }
        return values;
    }

    @Override
    public ChangeHistoryList parseChangeHistory(boolean withFieldLabels) {
        try {
            return ChangeHistoryParser.getChangeHistory(this.tester, withFieldLabels);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ChangeHistoryList parseChangeHistory() {
        return this.parseChangeHistory(false);
    }

    @Override
    public List<Comment> parseComments() {
        return CommentParser.getComments(this.tester);
    }

    @Override
    public List<Worklog> parseWorklogs() {
        return WorklogParser.getWorklogs(this.tester);
    }
}

