/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.rule;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class IssueTypeUrls
implements MethodRule {
    private Backdoor backdoor;
    private Map<String, IssueTypeControl.IssueType> nameToIssueTypeMap;
    private final Pattern pattern = Pattern.compile(".*?avatarId=(\\d+).*?");

    public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (BaseJiraRestTest.class.isAssignableFrom(target.getClass())) {
                    BaseJiraRestTest test = (BaseJiraRestTest)target;
                    Field backdoorField = BaseJiraRestTest.class.getDeclaredField("backdoor");
                    backdoorField.setAccessible(true);
                    IssueTypeUrls.this.backdoor = (Backdoor)backdoorField.get(test);
                    base.evaluate();
                    return;
                }
                if (BaseJiraFuncTest.class.isAssignableFrom(target.getClass())) {
                    BaseJiraFuncTest test = (BaseJiraFuncTest)target;
                    Field backdoorField = BaseJiraFuncTest.class.getDeclaredField("backdoor");
                    backdoorField.setAccessible(true);
                    IssueTypeUrls.this.backdoor = (Backdoor)backdoorField.get(test);
                    base.evaluate();
                    return;
                }
                throw new RuntimeException("Unsupported test case.");
            }
        };
    }

    @Deprecated
    public static IssueTypeUrls init(Backdoor backdoor) {
        IssueTypeUrls instance = new IssueTypeUrls();
        instance.backdoor = backdoor;
        return instance;
    }

    public String getIssueTypeUrl(String issueTypeName) {
        IssueTypeControl.IssueType issueType = this.getNameToIssueTypeMap().get(issueTypeName.toLowerCase());
        return issueType != null ? issueType.getIconUrl() : null;
    }

    public Long getAvatarId(String issueTypeName) {
        IssueTypeControl.IssueType issueType = this.getNameToIssueTypeMap().get(issueTypeName.toLowerCase());
        Matcher matcher = this.pattern.matcher(issueType.getIconUrl());
        if (matcher.find()) {
            try {
                return Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public void invalidateIssueTypeIconsCache() {
        this.nameToIssueTypeMap = null;
    }

    private Map<String, IssueTypeControl.IssueType> getNameToIssueTypeMap() {
        if (this.nameToIssueTypeMap == null) {
            List issueTypes = this.backdoor.issueType().getIssueTypes();
            this.nameToIssueTypeMap = issueTypes.stream().collect(Collectors.toMap(it -> it.getName().toLowerCase(), Function.identity()));
        }
        return this.nameToIssueTypeMap;
    }
}

