/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.setup;

import com.atlassian.jira.functest.framework.setup.PostgresContainer;
import com.atlassian.jira.functest.framework.util.text.MsgOfD;
import com.atlassian.jira.test.util.lic.License;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;

public class JiraSetupInstanceHelper {
    private static final long STARTUP_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(3L);
    private static final long STARTUP_POLL_INTERVAL_MILLIS = 1000L;
    private final WebTester tester;
    private final JIRAEnvironmentData jiraEnvironmentData;

    public JiraSetupInstanceHelper(WebTester tester, JIRAEnvironmentData jiraEnvironmentData) {
        this.tester = tester;
        this.jiraEnvironmentData = jiraEnvironmentData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void ensureJIRAIsReadyToGo() {
        FuncTestOut.log((Object)("Checking that JIRA is setup and ready to be tested..." + this.jiraEnvironmentData.getBaseUrl()));
        if (!this.isJiraSetup()) {
            this.detectJohnson();
            Class<JiraSetupInstanceHelper> clazz = JiraSetupInstanceHelper.class;
            // MONITORENTER : com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper.class
            this.setupJIRA();
            // MONITOREXIT : clazz
        }
        this.login("admin", "admin");
        FuncTestOut.log((Object)("JIRA is setup and 'admin' is logged in. " + new MsgOfD()));
    }

    public boolean isJiraSetup() {
        this.tester.beginAt("/");
        this.waitForStartupComplete();
        return this.hasBeenSetup();
    }

    private String getCurrentUrl() {
        return this.tester.getDialog().getResponse().getURL().getPath();
    }

    private boolean isStartupPage() {
        return (this.jiraEnvironmentData.getContext() + "/startup.jsp").equals(this.getCurrentUrl());
    }

    private void waitForStartupComplete() {
        if (!this.isStartupPage()) {
            return;
        }
        FuncTestOut.log((Object)"Looks like JIRA is still starting up.  Don't worry; I'm sure it'll ready any second, now...");
        long deadline = System.nanoTime() + STARTUP_TIMEOUT_NANOS;
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                throw new AssertionError("Interrupted", ie);
            }
            this.tester.beginAt("/");
            if (this.isStartupPage()) continue;
            return;
        } while (System.nanoTime() < deadline);
        Fail.fail((String)"Timeout");
    }

    private boolean hasBeenSetup() {
        String currentRelativePath;
        switch (currentRelativePath = StringUtils.removeStart((String)this.getCurrentUrl(), (String)this.jiraEnvironmentData.getContext())) {
            case "/secure/Dashboard.jspa": 
            case "/login.jsp": 
            case "/": {
                return true;
            }
        }
        return false;
    }

    private void detectJohnson() {
        String response = this.tester.getDialog().getResponseText();
        if (response.contains("JIRA Access Constraints")) {
            FuncTestOut.log((Object)("Test failed because we are getting the following johnson page:\n" + response));
            Fail.fail((String)"It appears that JIRA is currenty being Johnsoned.  That cant be good!");
        }
    }

    public void setupJIRAStepsInSet(EnumSet<SetupStage> stepsInRange) {
        try {
            for (SetupStage step : stepsInRange) {
                step.perform(this);
            }
        }
        catch (RuntimeException rte) {
            FuncTestOut.log((Object)("Unable to setup JIRA because of " + rte.getMessage()));
            throw rte;
        }
    }

    public void connectToTestDatabase(PostgresContainer dbContainer) {
        this.tester.checkCheckbox("databaseOption", "external");
        this.tester.setFormElement("databaseType", "postgres72");
        this.tester.setFormElement("jdbcHostname", "localhost");
        this.tester.setFormElement("jdbcPort", String.valueOf(dbContainer.getMappedPort(5432)));
        this.tester.setFormElement("jdbcDatabase", dbContainer.getDatabaseName());
        this.tester.setFormElement("jdbcUsername", dbContainer.getUsername());
        this.tester.setFormElement("jdbcPassword", dbContainer.getPassword());
        this.tester.setFormElement("schemaName", "public");
        this.tester.submit();
    }

    private void setupJIRA() {
        FuncTestOut.log((Object)"JIRA is not setup.  Installing a new V2 license and completing setup steps");
        try {
            this.setupJIRAStepsInSet(SetupStage.START.to(SetupStage.LICENSE.prev()));
            this.tester.assertTextPresent("your license key");
            SetupStage.LICENSE.perform(this);
            boolean step3Skipped = true;
            if (!this.tester.getDialog().isTextInResponse("Set up email notifications")) {
                step3Skipped = false;
                this.tester.assertTextPresent("Set up administrator account");
                SetupStage.ACCOUNT.perform(this);
            }
            this.tester.assertTextPresent("Set up email notifications");
            SetupStage.EMAIL.perform(this);
            if (step3Skipped) {
                this.tester.assertTextPresent("JIRA is now ready to use, please log in and get started.");
            } else {
                this.tester.assertLinkPresent("header-details-user-fullname");
            }
        }
        catch (RuntimeException rte) {
            FuncTestOut.log((Object)("Unable to setup JIRA because of " + rte.getMessage()));
            throw rte;
        }
    }

    private boolean isDatabaseSetUp() {
        return !this.tester.getDialog().hasForm("jira-setup-database");
    }

    private void withHiddenFieldsTemporarilyEditable(Runnable runnable) {
        boolean isHiddenFieldsEditable = this.tester.getDialog().getWebClient().getClientProperties().isHiddenFieldsEditable();
        if (!isHiddenFieldsEditable) {
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(true);
            runnable.run();
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(isHiddenFieldsEditable);
        } else {
            runnable.run();
        }
    }

    private void setupMode() {
        if (!this.tester.getDialog().isTextInResponse("Set up application properties")) {
            this.withHiddenFieldsTemporarilyEditable(() -> this.tester.setFormElement("setupOption", "classic"));
            this.tester.submit();
        }
    }

    private void setupDatabase() {
        if (!this.tester.getDialog().isTextInResponse("Set up application properties")) {
            if (StringUtils.isNotEmpty((CharSequence)this.jiraEnvironmentData.getProperty("databaseType"))) {
                FuncTestOut.log((Object)"Setting up external db");
                JiraSetupInstanceHelper.setupDirectJDBCConnection(this.tester, this.jiraEnvironmentData);
            } else {
                FuncTestOut.log((Object)"Setting up internal db");
                this.tester.checkCheckbox("databaseOption", "internal");
                this.tester.submit();
            }
        }
        Assertions.assertThat((String)this.tester.getDialog().getResponseText()).contains(new CharSequence[]{"Set up application properties"});
    }

    public static void setupDirectJDBCConnection(WebTester webTester, JIRAEnvironmentData environmentData) {
        webTester.checkCheckbox("databaseOption", "external");
        webTester.setFormElement("databaseType", environmentData.getProperty("databaseType"));
        webTester.setFormElement("jdbcHostname", environmentData.getProperty("db.host"));
        webTester.setFormElement("jdbcPort", environmentData.getProperty("db.port"));
        webTester.setFormElement("jdbcSid", environmentData.getProperty("db.instance"));
        webTester.setFormElement("jdbcDatabase", environmentData.getProperty("db.instance"));
        webTester.setFormElement("jdbcUsername", environmentData.getProperty("username"));
        webTester.setFormElement("jdbcPassword", environmentData.getProperty("password"));
        webTester.setFormElement("schemaName", environmentData.getProperty("schema-name"));
        webTester.submit();
    }

    private void setupJiraAdminAccount(String username, String password, String fullName, String email) {
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", password);
        this.tester.setFormElement("confirm", password);
        this.tester.setFormElement("fullname", fullName);
        this.tester.setFormElement("email", email);
        this.tester.submit();
    }

    private void setupJiraEmailNotifications() {
        this.tester.submit("finish");
    }

    private void setupJiraApplicationProperties() {
        this.tester.setFormElement("title", "Your Company JIRA");
        this.tester.submit();
    }

    private void setupJiraUsingExistingLicense(License licenseKey, String buildType) {
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.setFormElement("setupLicenseKey", licenseKey.getLicenseString());
        this.tester.submit();
        this.tester.assertTextNotPresent("Invalid license type for this edition of JIRA. License should be of type " + buildType + ".");
    }

    private void login(String username, String password) {
        this.tester.beginAt("/login.jsp");
        this.tester.setFormElement("os_username", username);
        this.tester.setFormElement("os_password", password);
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
    }

    public static enum SetupStage {
        START{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
            }
        }
        ,
        MODE{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.setupMode();
            }
        }
        ,
        DATABASE{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                if (!helper.isDatabaseSetUp()) {
                    helper.setupDatabase();
                }
            }
        }
        ,
        APPLICATION_PROPERTIES{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.setupJiraApplicationProperties();
            }
        }
        ,
        LICENSE{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.setupJiraUsingExistingLicense(LicenseKeys.MULTI_ROLE_DC, "renaissance");
            }
        }
        ,
        ACCOUNT{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.setupJiraAdminAccount("admin", "admin", "Administrator", "admin@stuff.com.com");
            }
        }
        ,
        EMAIL{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.setupJiraEmailNotifications();
            }
        }
        ,
        LOGIN{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.login("admin", "admin");
            }
        }
        ,
        END{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
            }
        };

        private static NavigableSet<SetupStage> NAVIGABLE_ENUMS;

        protected abstract void perform(JiraSetupInstanceHelper var1);

        public SetupStage next() {
            SetupStage nextOrNull = NAVIGABLE_ENUMS.higher(this);
            if (null == nextOrNull) {
                throw new NoSuchElementException("no next item for: " + (Object)((Object)this));
            }
            return nextOrNull;
        }

        public SetupStage prev() {
            SetupStage prevOrNull = NAVIGABLE_ENUMS.lower(this);
            if (null == prevOrNull) {
                throw new NoSuchElementException("no prev item for: " + (Object)((Object)this));
            }
            return prevOrNull;
        }

        public EnumSet<SetupStage> to(SetupStage endStage) {
            if (this.compareTo(endStage) > 0) {
                return EnumSet.noneOf(SetupStage.class);
            }
            return EnumSet.range(this, endStage);
        }

        static {
            NAVIGABLE_ENUMS = Sets.newTreeSet(Arrays.asList(SetupStage.values()));
        }
    }
}

