/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.suite.SuiteTransform;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Sorter;

public final class Transforms {
    private Transforms() {
        throw new AssertionError((Object)"Don't instantiate me!");
    }

    public static SuiteTransform fromSorter(final Sorter sorter) {
        return new SuiteTransform(){

            public Iterable<Description> apply(@Nullable Iterable<Description> descriptions) {
                ArrayList answer = Lists.newArrayList(descriptions);
                Collections.sort(answer, new Comparator<Description>(){

                    @Override
                    public int compare(Description first, Description second) {
                        return sorter.compare(first, second);
                    }
                });
                return answer;
            }
        };
    }

    public static SuiteTransform fromFilter(final Filter filter) {
        return new SuiteTransform(){

            public Iterable<Description> apply(@Nullable Iterable<Description> descriptions) {
                return Iterables.filter(descriptions, (Predicate)new Predicate<Description>(){

                    public boolean apply(Description input) {
                        return filter.shouldRun(input);
                    }
                });
            }
        };
    }
}

