/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util;

import com.atlassian.jira.functest.framework.util.FilteredSearcherGroup;
import com.atlassian.jira.functest.framework.util.SearchResults;
import com.atlassian.jira.functest.framework.util.Searcher;
import com.atlassian.jira.functest.framework.util.Searchers;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class SearchersClient
extends RestApiClient<SearchersClient> {
    private final com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;

    public SearchersClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
        this.environmentData = environmentData;
    }

    public List<Searcher> allSearchers(String jqlContext) {
        return this.asList(this.getSearchers((String)jqlContext).searchers);
    }

    private List<Searcher> asList(Searchers searchers) {
        ArrayList set = Lists.newArrayList();
        for (FilteredSearcherGroup group : searchers.getGroups()) {
            for (Searcher searcher : group.getSearchers()) {
                set.add(searcher);
            }
        }
        return set;
    }

    public SearchResults getSearchersBasic(String ... params) {
        return (SearchResults)this.basic(params).request().get(SearchResults.class);
    }

    public SearchResults getSearchers(String jqlContext) {
        return (SearchResults)this.searchers(jqlContext).request().get(SearchResults.class);
    }

    public ParsedResponse<String> getSearchersResponse(String jqlContext) {
        return this.toResponse(() -> (Response)this.searchers(jqlContext).request().get(Response.class), String.class);
    }

    private WebTarget basic(String ... params) {
        WebTarget resource = this.createResource().path("QueryComponent!Default.jspa").queryParam("decorator", new Object[]{"none"});
        for (int i = 0; i < params.length; i += 2) {
            resource = resource.queryParam(params[i], new Object[]{params[i + 1]});
        }
        return resource;
    }

    private WebTarget searchers(String jqlContext) {
        WebTarget resource = this.createResource().path("secure/QueryComponent!Jql.jspa").queryParam("decorator", new Object[]{"none"});
        if (null != jqlContext) {
            resource = resource.queryParam("jql", new Object[]{jqlContext});
        }
        return resource;
    }

    protected WebTarget createResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm());
    }
}

