/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.dom;

import com.atlassian.jira.functest.framework.util.dom.DomKit;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class DomBetterNode {
    private static final Class[] PROXIED_DOM_CLASSES = new Class[]{Node.class, Element.class, Document.class, Attr.class, Text.class, Notation.class, CDATASection.class, CharacterData.class, DocumentFragment.class, ProcessingInstruction.class, DocumentType.class};

    DomBetterNode() {
    }

    static Node betterNode(Node node) {
        Class<?> objClass;
        if (node != null && !DomBetterNode.isAlreadyProxied(objClass = node.getClass())) {
            return (Node)Proxy.newProxyInstance(objClass.getClassLoader(), PROXIED_DOM_CLASSES, (InvocationHandler)new BetterNodeInvocationHandler(node));
        }
        return node;
    }

    private static boolean isAlreadyProxied(Class aClass) {
        return Proxy.isProxyClass(aClass);
    }

    private static class BetterNodeInvocationHandler
    implements InvocationHandler {
        private Node wrappedNode;

        private BetterNodeInvocationHandler(Node wrappedNode) {
            this.wrappedNode = wrappedNode;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName()) && method.getReturnType().equals(String.class) && method.getParameterTypes().length == 0) {
                return this.betterToString();
            }
            Class<?> returnType = method.getReturnType();
            Object returnValue = method.invoke((Object)this.wrappedNode, args);
            if (Node.class.isAssignableFrom(returnType) && returnValue != null) {
                return DomBetterNode.betterNode((Node)returnValue);
            }
            return returnValue;
        }

        private String betterToString() {
            StringBuilder sb = new StringBuilder().append(this.wrappedNode.getNodeName()).append("-->").append(DomKit.getCollapsedText(this.wrappedNode));
            return sb.toString();
        }
    }
}

