/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.junit;

import com.atlassian.jira.util.dbc.Assertions;
import java.lang.annotation.Annotation;
import org.junit.runner.Description;

public class AnnotatedDescription {
    private final Description description;

    public AnnotatedDescription(Description description) {
        this.description = Assertions.notNull(description);
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> annotation) {
        return this.getAnnotation(annotation) != null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        A fromTest = this.getAnnotationFromTestMethod(annotation);
        if (fromTest == null) {
            fromTest = this.getAnnotationFromTestClass(annotation);
        }
        return fromTest;
    }

    public <A extends Annotation> A getAnnotationFromTestMethod(Class<A> annotation) {
        if (this.description.isTest()) {
            return (A)this.description.getAnnotation(annotation);
        }
        return null;
    }

    public <A extends Annotation> A getAnnotationFromTestClass(Class<A> annotation) {
        if (this.description.isTest()) {
            return this.description.getTestClass().getAnnotation(annotation);
        }
        return (A)this.description.getAnnotation(annotation);
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.getAnnotation(annotation) != null;
    }

    public boolean isMethodAnnotated(Class<? extends Annotation> annotation) {
        return this.getAnnotationFromTestMethod(annotation) != null;
    }

    public boolean isClassAnnotated(Class<? extends Annotation> annotation) {
        return this.getAnnotationFromTestClass(annotation) != null;
    }

    public String toString() {
        return this.description.toString();
    }
}

