/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.atlassian.jira.util.DomFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.assertj.core.api.AbstractAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BuildNumberAssert
extends AbstractAssert<BuildNumberAssert, FileInputStream> {
    public BuildNumberAssert(FileInputStream inputStream) {
        super((Object)inputStream, BuildNumberAssert.class);
    }

    public static BuildNumberAssert assertThat(FileInputStream inputStream) {
        return new BuildNumberAssert(inputStream);
    }

    public BuildNumberAssert hasBuildNumber(int expectedBuildNumber) {
        try {
            Document doc = DomFactory.createDocumentBuilder().parse((InputStream)this.actual);
            if (this.readBuildNumberFrom(doc) != expectedBuildNumber) {
                this.failWithMessage("Build number should be equal to " + expectedBuildNumber, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    protected int readBuildNumberFrom(Document doc) throws Exception {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        XPathExpression findOsPropertyId = xpath.compile("//OSPropertyEntry[@propertyKey='jira.version.patched']");
        Node osPropertyEntry = (Node)findOsPropertyId.evaluate(doc, XPathConstants.NODE);
        if (osPropertyEntry != null) {
            String osPropertyId = osPropertyEntry.getAttributes().getNamedItem("id").getTextContent();
            XPathExpression findOsPropertyString = xpath.compile(String.format("//OSPropertyString[@id='%s']", osPropertyId));
            Node osPropertyString = (Node)findOsPropertyString.evaluate(doc, XPathConstants.NODE);
            if (osPropertyString != null) {
                return Integer.valueOf(osPropertyString.getAttributes().getNamedItem("value").getTextContent());
            }
        }
        throw new RuntimeException();
    }
}

