/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueLink;
import com.google.common.base.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class LinkedIssuesMatcher
extends TypeSafeMatcher<Issue> {
    private final String expectedIssueKey;
    private final String expectedLinkTypeName;
    private final boolean outward;

    public static Matcher<Issue> hasLinkWithInwardIssue(String issueKey, String linkTypeName) {
        return new LinkedIssuesMatcher(issueKey, linkTypeName, false);
    }

    public static Matcher<Issue> hasLinkWithOutwardIssue(String issueKey, String linkTypeName) {
        return new LinkedIssuesMatcher(issueKey, linkTypeName, true);
    }

    public LinkedIssuesMatcher(String expectedIssueKey, String expectedLinkTypeName, boolean outward) {
        this.expectedIssueKey = expectedIssueKey;
        this.expectedLinkTypeName = expectedLinkTypeName;
        this.outward = outward;
    }

    public boolean matchesSafely(Issue issue) {
        if (issue != null && issue.fields != null && issue.fields.issuelinks != null) {
            for (IssueLink issueLink : issue.fields.issuelinks) {
                String linkedIssueKey;
                IssueLink.IssueLinkRef linkedIssue = this.outward ? issueLink.outwardIssue() : issueLink.inwardIssue();
                String linkTypeName = issueLink.type() != null ? issueLink.type().name() : null;
                String string = linkedIssueKey = linkedIssue != null ? linkedIssue.key() : null;
                if (!Objects.equal((Object)this.expectedLinkTypeName, (Object)linkTypeName) || !Objects.equal((Object)this.expectedIssueKey, (Object)linkedIssueKey)) continue;
                return true;
            }
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("an Issue containing a link to ").appendValue((Object)this.expectedIssueKey).appendText(" with description ").appendValue((Object)this.expectedLinkTypeName);
    }
}

