/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.google.common.collect.ImmutableList;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.assertj.core.api.Assertions;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MimeMessageMatchers {
    public static Matcher<MimeMessage> containsString(final String text) {
        com.atlassian.jira.util.dbc.Assertions.notNull("text", text);
        return new MimeMessageTypeSafeMatcher(){

            protected boolean matchesSafely(MimeMessage message) {
                String emailBody = GreenMailUtil.getBody((Part)message);
                return emailBody.contains(text);
            }

            public void describeTo(Description description) {
                description.appendText("MimeMessage that body contains: ").appendValue((Object)text);
            }

            @Override
            Object getActualValue(MimeMessage item) {
                return GreenMailUtil.getBody((Part)item);
            }
        };
    }

    public static Matcher<MimeMessage> hasNumberOfParts(final int expectedNumOfParts) {
        return new MimeMessageTypeSafeMatcher(){

            protected boolean matchesSafely(MimeMessage message) {
                try {
                    return expectedNumOfParts == this.getNumOfParts(message);
                }
                catch (IOException | MessagingException e) {
                    throw new RuntimeException(e);
                }
            }

            private int getNumOfParts(MimeMessage message) throws IOException, MessagingException {
                Object emailContent = message.getContent();
                if (emailContent instanceof Multipart) {
                    Multipart multiPart = (Multipart)emailContent;
                    return multiPart.getCount();
                }
                return -1;
            }

            public void describeTo(Description description) {
                description.appendText("MimeMessage with number of parts=").appendValue((Object)expectedNumOfParts);
            }

            @Override
            Object getActualValue(MimeMessage item) throws Exception {
                return this.getNumOfParts(item);
            }
        };
    }

    public static Matcher<MimeMessage> withRecipientEqualTo(final Collection<String> expectedToAddresses) {
        com.atlassian.jira.util.dbc.Assertions.notNull("expectedToAddresses", expectedToAddresses);
        return new MimeMessageTypeSafeMatcher(){

            protected boolean matchesSafely(MimeMessage message) {
                try {
                    return expectedToAddresses.equals(MimeMessageMatchers.getActualAddresses(message, "to"));
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            }

            public void describeTo(Description description) {
                description.appendText("MimeMessage that to address is: ").appendValue((Object)expectedToAddresses);
            }

            @Override
            Object getActualValue(MimeMessage item) throws Exception {
                return MimeMessageMatchers.getActualAddresses(item, "to");
            }
        };
    }

    private static Collection<String> getActualAddresses(MimeMessage message, String field) throws MessagingException {
        Object[] addressHeader = message.getHeader(field);
        Assertions.assertThat((Object[])addressHeader).hasSize(1);
        return MimeMessageMatchers.parseEmailAddresses((String)addressHeader[0]);
    }

    public static Matcher<MimeMessage> withRecipientEqualTo(String expectedTo) {
        return MimeMessageMatchers.withRecipientEqualTo((Collection<String>)ImmutableList.of((Object)expectedTo));
    }

    public static Matcher<MimeMessage> withCcEqualTo(final Collection<String> expectedCcAddresses) {
        com.atlassian.jira.util.dbc.Assertions.notNull("expectedCcAddresses", expectedCcAddresses);
        return new MimeMessageTypeSafeMatcher(){

            protected boolean matchesSafely(MimeMessage message) {
                try {
                    return expectedCcAddresses.equals(MimeMessageMatchers.getActualAddresses(message, "cc"));
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            }

            public void describeTo(Description description) {
                description.appendText("MimeMessage that cc address is: ").appendValue((Object)expectedCcAddresses);
            }

            @Override
            Object getActualValue(MimeMessage item) throws Exception {
                return MimeMessageMatchers.getActualAddresses(item, "cc");
            }
        };
    }

    public static Matcher<MimeMessage> withFromEqualTo(final String expectedFrom) {
        com.atlassian.jira.util.dbc.Assertions.notNull("expectedFrom", expectedFrom);
        return new MimeMessageTypeSafeMatcher(){

            protected boolean matchesSafely(MimeMessage message) {
                try {
                    Object[] adresses = message.getHeader("from");
                    Assertions.assertThat((Object[])adresses).hasSize(1);
                    Collection actualAddresses = MimeMessageMatchers.parseEmailAddresses((String)adresses[0]);
                    return ImmutableList.of((Object)expectedFrom).equals((Object)actualAddresses);
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            }

            public void describeTo(Description description) {
                description.appendText("MimeMessage that from address is: ").appendValue((Object)expectedFrom);
            }

            @Override
            Object getActualValue(MimeMessage item) throws Exception {
                return MimeMessageMatchers.getActualAddresses(item, "from");
            }
        };
    }

    public static Matcher<MimeMessage> withSubjectEqualTo(final String subject) {
        com.atlassian.jira.util.dbc.Assertions.notNull("subject", subject);
        return new MimeMessageTypeSafeMatcher(){

            protected boolean matchesSafely(MimeMessage message) {
                try {
                    return subject.equals(message.getSubject());
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            }

            public void describeTo(Description description) {
                description.appendText("MimeMessage that subject is: ").appendValue((Object)subject);
            }

            @Override
            Object getActualValue(MimeMessage item) throws Exception {
                return item.getSubject();
            }
        };
    }

    public static Matcher<MimeMessage> containsContentType(final String contentType) {
        com.atlassian.jira.util.dbc.Assertions.notNull("contentType", contentType);
        return new MimeMessageTypeSafeMatcher(){

            protected boolean matchesSafely(MimeMessage message) {
                try {
                    Object content = message.getContent();
                    if (content instanceof Multipart) {
                        Multipart multipart = (Multipart)content;
                        for (int i = 0; i < multipart.getCount(); ++i) {
                            BodyPart bodyPart = multipart.getBodyPart(i);
                            if (!contentType.equals(bodyPart.getContentType())) continue;
                            return true;
                        }
                    }
                    return contentType.equals(message.getContentType());
                }
                catch (IOException | MessagingException e) {
                    throw new RuntimeException(e);
                }
            }

            public void describeTo(Description description) {
                description.appendText("MimeMessage that has content type: ").appendValue((Object)contentType);
            }

            @Override
            Object getActualValue(MimeMessage item) throws Exception {
                return item.getContentType();
            }
        };
    }

    public static Matcher<MimeMessage> hasHtmlContentType() {
        return MimeMessageMatchers.containsContentType("text/html; charset=UTF-8");
    }

    public static Matcher<MimeMessage> hasTextContentType() {
        return MimeMessageMatchers.containsContentType("text/plain; charset=UTF-8");
    }

    public static Matcher<MimeMessage> withBodyMatching(final String regex) {
        com.atlassian.jira.util.dbc.Assertions.notNull("regex", regex);
        return new MimeMessageTypeSafeMatcher(){

            protected boolean matchesSafely(MimeMessage message) {
                String emailBody = GreenMailUtil.getBody((Part)message);
                Pattern pattern = Pattern.compile(regex, 8);
                java.util.regex.Matcher match = pattern.matcher(emailBody);
                return match.find();
            }

            public void describeTo(Description description) {
                description.appendText("MimeMessage that matches: ").appendValue((Object)regex);
            }

            @Override
            Object getActualValue(MimeMessage item) throws Exception {
                return GreenMailUtil.getBody((Part)item);
            }
        };
    }

    private static Collection<String> parseEmailAddresses(String emails) {
        StringTokenizer st = new StringTokenizer(emails, ",");
        ArrayList<String> emailList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String email = st.nextToken().trim();
            if (!TextUtils.stringSet((String)email)) continue;
            emailList.add(email.trim());
        }
        return emailList;
    }

    private static abstract class MimeMessageTypeSafeMatcher
    extends TypeSafeMatcher<MimeMessage> {
        private MimeMessageTypeSafeMatcher() {
        }

        protected final void describeMismatchSafely(MimeMessage item, Description mismatchDescription) {
            try {
                mismatchDescription.appendText("was ").appendValue(this.getActualValue(item));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        abstract Object getActualValue(MimeMessage var1) throws Exception;
    }
}

