/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.util.ObjectUtils;
import com.google.common.base.Strings;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class PermissionSchemesMatcher {
    public static Matcher<PermissionSchemeBean> hasPermission(String permissionKey, String type, String parameter) {
        return new HasPermission(permissionKey, type, parameter);
    }

    public static Matcher<PermissionSchemeBean> hasPermissionCount(String type, String parameter, Integer expectedMatchingPermissions) {
        return new HasPermissionCount(type, parameter, expectedMatchingPermissions);
    }

    private static class HasPermissionCount
    extends TypeSafeMatcher<PermissionSchemeBean> {
        final String type;
        final String parameter;
        final Integer expectedMatchingPermissions;

        public HasPermissionCount(String type, String parameter, Integer expectedMatchingPermissions) {
            this.type = type;
            this.parameter = parameter;
            this.expectedMatchingPermissions = expectedMatchingPermissions;
        }

        protected boolean matchesSafely(PermissionSchemeBean permissionSchemeBean) {
            if (permissionSchemeBean.getPermissions() == null) {
                return 0 == this.expectedMatchingPermissions;
            }
            long matchCount = permissionSchemeBean.getPermissions().stream().filter(permissionGrantBean -> ObjectUtils.equalsNullSafe((Object)permissionGrantBean.getHolder().getType(), (Object)this.type) && ObjectUtils.equalsNullSafe((Object)permissionGrantBean.getHolder().getParameter(), (Object)this.parameter)).count();
            return matchCount == (long)this.expectedMatchingPermissions.intValue();
        }

        public void describeTo(Description description) {
            description.appendText("expected ").appendValue((Object)this.expectedMatchingPermissions).appendText(" permission matches of type ").appendValue((Object)this.type).appendText(" and value: ").appendValue((Object)this.parameter);
        }
    }

    private static class HasPermission
    extends TypeSafeMatcher<PermissionSchemeBean> {
        final String permissionKey;
        final String type;
        final String parameter;

        public HasPermission(String permissionKey, String type, String parameter) {
            this.permissionKey = permissionKey;
            this.type = type;
            this.parameter = parameter;
        }

        protected boolean matchesSafely(PermissionSchemeBean permissionSchemeBean) {
            if (permissionSchemeBean.getPermissions() == null) {
                return false;
            }
            return permissionSchemeBean.getPermissions().stream().anyMatch(permissionGrantBean -> permissionGrantBean.getPermission().equals(this.permissionKey) && ObjectUtils.equalsNullSafe((Object)Strings.nullToEmpty((String)permissionGrantBean.getHolder().getType()), (Object)Strings.nullToEmpty((String)this.type)) && ObjectUtils.equalsNullSafe((Object)Strings.nullToEmpty((String)permissionGrantBean.getHolder().getParameter()), (Object)Strings.nullToEmpty((String)this.parameter)));
        }

        public void describeTo(Description description) {
            description.appendText("permission ").appendValue((Object)this.permissionKey).appendText(" with type ").appendValue((Object)this.type).appendText(" and value: ").appendValue((Object)this.parameter);
        }
    }
}

