/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookListener;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class WebHookMatchers {
    public static Matcher<List<? extends WebHookRegistrationClient.RegistrationResponse>> containsWebHook(final WebHookListener listener) {
        return new TypeSafeMatcher<List<? extends WebHookRegistrationClient.RegistrationResponse>>(){

            protected boolean matchesSafely(List<? extends WebHookRegistrationClient.RegistrationResponse> registrationResponses) {
                return Iterables.any(registrationResponses, (Predicate)new Predicate<WebHookRegistrationClient.RegistrationResponse>(){

                    public boolean apply(WebHookRegistrationClient.RegistrationResponse response) {
                        return this.matches(response);
                    }
                });
            }

            public void describeTo(Description description) {
                description.appendText("WebHook response doesn't contain " + listener);
            }

            public boolean matches(WebHookRegistrationClient.RegistrationResponse response) {
                return response.name.equals(listener.getName()) && response.url.equals(listener.getUrl()) && Sets.newHashSet((Object[])response.events).equals(Sets.newHashSet((Object[])listener.getEvents())) && response.getFilterForIssueSection().equals(listener.getFilter()) && Boolean.valueOf(response.excludeBody).equals(listener.isExcludeIssueDetails()) && response.self.endsWith("/" + listener.getId());
            }
        };
    }
}

