/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.BackdoorModule;
import com.atlassian.jira.functest.framework.DevMode;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.util.junit.AnnotatedDescription;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DevModeRule
extends TestWatcher {
    private Backdoor backdoor;
    private Boolean stateAfter = null;

    @Inject
    public DevModeRule(Backdoor backdoor) {
        this.backdoor = backdoor;
    }

    public DevModeRule(BackdoorModule backdoorModule) {
        this.backdoor = backdoorModule.getBackdoor();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                DevModeRule.this.starting(description);
                base.evaluate();
                DevModeRule.this.finished();
            }
        };
    }

    protected void starting(@Nonnull Description description) {
        AnnotatedDescription annotatedDescription = new AnnotatedDescription(description);
        if (!annotatedDescription.isMethodAnnotated(DevMode.class) && !annotatedDescription.isClassAnnotated(DevMode.class)) {
            return;
        }
        this.stateAfter = this.getDevMode();
        this.setDevMode(annotatedDescription.getAnnotation(DevMode.class).enabled());
    }

    protected void finished() {
        if (this.stateAfter == null) {
            return;
        }
        this.setDevMode(this.stateAfter);
    }

    private void setDevMode(Boolean devMode) {
        if (devMode != null) {
            this.backdoor.systemProperties().setProperty("jira.dev.mode", String.valueOf(devMode));
            this.backdoor.systemProperties().setProperty("atlassian.dev.mode", String.valueOf(devMode));
        } else {
            this.backdoor.systemProperties().unsetProperty("jira.dev.mode");
            this.backdoor.systemProperties().unsetProperty("atlassian.dev.mode");
        }
        this.backdoor.cacheControl().flushCaches();
    }

    private Boolean getDevMode() {
        try {
            return "true".equals(this.backdoor.systemProperties().getProperty("jira.dev.mode")) || "true".equals(this.backdoor.systemProperties().getProperty("atlassian.dev.mode"));
        }
        catch (WebApplicationException ex) {
            return null;
        }
    }
}

