/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.rule.MailTest;
import com.atlassian.jira.webtests.JIRAServerSetup;
import com.atlassian.jira.webtests.util.mail.MailService;
import java.net.BindException;
import java.util.function.Supplier;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class OutgoingMailConfigureSmtpRule
extends TestWatcher {
    private final String from;
    private final String prefix;
    private final JIRAServerSetup[] jiraServerSetups;
    private final Supplier<Backdoor> backdoorSupplier;
    private final MailService mailService;

    OutgoingMailConfigureSmtpRule(String from, String prefix, Supplier<Backdoor> backdoorSupplier, MailService mailService, JIRAServerSetup ... jiraServerSetups) {
        this.from = from;
        this.prefix = prefix;
        this.jiraServerSetups = jiraServerSetups;
        this.backdoorSupplier = backdoorSupplier;
        this.mailService = mailService;
    }

    protected void starting(Description description) {
        if (this.shouldFire(description)) {
            Backdoor backdoor = this.backdoorSupplier.get();
            try {
                this.mailService.configureAndStartGreenMail(this.jiraServerSetups);
                int smtpPort = this.mailService.getSmtpPort();
                try {
                    backdoor.mailServers().addSmtpServer(this.from, this.prefix, smtpPort);
                }
                catch (Exception e) {
                    throw new RuntimeException("Adding smtp server failed. Check that no -Datlassian.mail.senddisabled=true parameter is present.", e);
                }
            }
            catch (BindException e) {
                throw new RuntimeException(e);
            }
            if (!backdoor.getTestkit().mailServers().isSmtpConfigured()) {
                throw new RuntimeException("Smtp is not configured properly. Check if smtp server was added, and no -Datlassian.mail.senddisabled=true parameter is present.");
            }
        }
    }

    protected void finished(Description description) {
        if (this.shouldFire(description)) {
            this.mailService.stop();
        }
    }

    private boolean shouldFire(Description description) {
        return description.getAnnotation(MailTest.class) != null || description.getTestClass().getAnnotation(MailTest.class) != null;
    }
}

