/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.RestoreBlankDataCenterInstance;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.RestoreBlankServerInstance;
import com.atlassian.jira.functest.framework.RestoreDataCenterInstance;
import com.atlassian.jira.functest.framework.RestoreServerInstance;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RestoreDataRule
implements TestRule {
    private final Supplier<Backdoor> backdoorSupplier;

    public RestoreDataRule(Supplier<Backdoor> backdoorSupplier) {
        this.backdoorSupplier = backdoorSupplier;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RestoreDataRule.this.tryInitializeData(description);
                base.evaluate();
            }
        };
    }

    private void tryInitializeData(Description description) {
        if (!this.restoreByAnnotation((RestoreBlankDataCenterInstance)description.getAnnotation(RestoreBlankDataCenterInstance.class), (RestoreBlankServerInstance)description.getAnnotation(RestoreBlankServerInstance.class), (RestoreBlankInstance)description.getAnnotation(RestoreBlankInstance.class), (RestoreDataCenterInstance)description.getAnnotation(RestoreDataCenterInstance.class), (RestoreServerInstance)description.getAnnotation(RestoreServerInstance.class), (Restore)description.getAnnotation(Restore.class))) {
            Class testClass = description.getTestClass();
            this.restoreByAnnotation(testClass.getAnnotation(RestoreBlankDataCenterInstance.class), testClass.getAnnotation(RestoreBlankServerInstance.class), testClass.getAnnotation(RestoreBlankInstance.class), testClass.getAnnotation(RestoreDataCenterInstance.class), testClass.getAnnotation(RestoreServerInstance.class), testClass.getAnnotation(Restore.class));
        }
    }

    private boolean restoreByAnnotation(RestoreBlankDataCenterInstance restoreBlankDC, RestoreBlankServerInstance restoreBlankServer, RestoreBlankInstance restoreBlank, RestoreDataCenterInstance restoreDC, RestoreServerInstance restoreServer, Restore restore) {
        if (Stream.of(restoreBlankDC, restoreBlankServer, restoreBlank, restoreDC, restoreServer, restore).filter(Objects::nonNull).count() > 1L) {
            throw new IllegalArgumentException("Use only one of Restore annotations");
        }
        if (restoreBlankDC != null) {
            Backdoor backdoor = this.backdoorSupplier.get();
            backdoor.restoreBlankDataCenterInstance();
            backdoor.flags().clearFlags();
            return true;
        }
        if (restoreBlankServer != null) {
            Backdoor backdoor = this.backdoorSupplier.get();
            backdoor.restoreBlankServerInstance();
            backdoor.flags().clearFlags();
            return true;
        }
        if (restoreBlank != null) {
            Backdoor backdoor = this.backdoorSupplier.get();
            backdoor.restoreBlankInstance();
            backdoor.flags().clearFlags();
            return true;
        }
        if (restoreDC != null) {
            Backdoor backdoor = this.backdoorSupplier.get();
            backdoor.restoreDataCenterInstance(restoreDC.value());
            backdoor.flags().clearFlags();
            return true;
        }
        if (restoreServer != null) {
            Backdoor backdoor = this.backdoorSupplier.get();
            backdoor.restoreServerInstance(restoreServer.value());
            backdoor.flags().clearFlags();
            return true;
        }
        if (restore != null) {
            Backdoor backdoor = this.backdoorSupplier.get();
            backdoor.restoreDataFromResource(restore.value());
            backdoor.flags().clearFlags();
            return true;
        }
        return false;
    }
}

