/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.BackdoorModule;
import com.atlassian.jira.functest.rule.StatementDecorator;
import com.google.inject.Inject;
import java.util.Properties;
import javax.ws.rs.WebApplicationException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnOffAnalyticsRule
implements TestRule {
    private static final String DO_NOT_DISABLE_ANALYTICS_FLAG = "atlassian.jira.do.not.disable.analytics.in.tests";
    private static final Logger log = LoggerFactory.getLogger(TurnOffAnalyticsRule.class);
    private final BackdoorModule backdoor;

    @Inject
    public TurnOffAnalyticsRule(BackdoorModule backdoor) {
        this.backdoor = backdoor;
    }

    public Statement apply(Statement base, Description description) {
        return new StatementDecorator(base, this::disableAnalytics);
    }

    protected void disableAnalytics() {
        try {
            Properties systemProperties = System.getProperties();
            String doNotDisable = systemProperties.getProperty(DO_NOT_DISABLE_ANALYTICS_FLAG, "false");
            if (!doNotDisable.equals("true")) {
                log.debug("Disabling analytics");
                this.backdoor.get().analyticsEventsControl().disable();
            } else {
                log.debug("Skipping analytics disabling, the atlassian.jira.do.not.disable.analytics.in.tests is set to 'true' ");
            }
        }
        catch (WebApplicationException e) {
            log.warn("Could not disable analytics, this may lead to failures of import and flakiness!", (Throwable)e);
        }
    }
}

