/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class SearchResultMatcher {
    public static TypeSafeMatcher<SearchResult> issues(String ... issueKeys) {
        return SearchResultMatcher.issues(Lists.newArrayList((Object[])issueKeys));
    }

    public static TypeSafeMatcher<SearchResult> issues(List<String> issueKeys) {
        return SearchResultMatcher.issues(Sets.newHashSet(issueKeys));
    }

    private static TypeSafeMatcher<SearchResult> issues(final Set<String> issueKeys) {
        return new TypeSafeMatcher<SearchResult>(){

            protected boolean matchesSafely(SearchResult searchResult) {
                return searchResult.total.intValue() == issueKeys.size() && Iterables.all((Iterable)searchResult.issues, (Predicate)new Predicate<Issue>(){

                    public boolean apply(Issue issue) {
                        return issueKeys.contains(issue.key);
                    }
                });
            }

            public void describeTo(Description description) {
                description.appendText("Search result does not contain issues").appendValue((Object)issueKeys);
            }
        };
    }
}

