/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.TransformingCollection;
import com.atlassian.jira.util.collect.TransformingIterable;
import com.atlassian.jira.util.collect.TransformingIterator;
import com.atlassian.jira.util.collect.TransformingList;
import com.atlassian.jira.util.collect.TransformingMap;
import com.atlassian.jira.util.collect.TransformingSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Transformed {
    public static <K, I, V> Map<K, V> map(Map<K, I> map, Function<I, V> transformer) {
        return new TransformingMap<K, V, I>(map, transformer);
    }

    public static <K, I, V> Map.Entry<K, V> entry(Map.Entry<? extends K, ? extends I> entry, Function<I, V> transformer) {
        return new TransformingMap.DecoratedEntry<K, I, V>(entry, transformer);
    }

    public static <I, E> Set<E> set(Set<I> set, Function<I, E> transformer) {
        return new TransformingSet<I, E>(set, transformer);
    }

    public static <I, E> List<E> list(List<I> set, Function<I, E> transformer) {
        return new TransformingList<I, E>(set, transformer);
    }

    public static <I, E> Collection<E> collection(Collection<? extends I> collection, Function<I, E> transformer) {
        return new TransformingCollection<I, E>(collection, transformer);
    }

    public static <I, E> EnclosedIterable<E> enclosedIterable(EnclosedIterable<I> iterable, Function<I, E> transformer) {
        return new TransformingIterable<I, E>(iterable, transformer);
    }

    public static <I, E> Iterator<E> iterator(Iterator<? extends I> set, Function<I, E> transformer) {
        return new TransformingIterator<I, E>(set, transformer);
    }

    private Transformed() {
        throw new AssertionError();
    }
}

