/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.matchers.RegexMatchers;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.JIRAServerSetup;
import com.atlassian.jira.webtests.util.mail.MailService;
import com.google.common.collect.Sets;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.opensymphony.util.TextUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class EmailBaseFuncTestCase
extends BaseJiraFuncTest
implements FunctTestConstants {
    public static final String DEFAULT_FROM_ADDRESS = "jiratest@atlassian.com";
    public static final String DEFAULT_SUBJECT_PREFIX = "[JIRATEST]";
    public static final String newline = "\r\n";
    public static final String HTML_FORMAT_REGEX = "<body class=\"jira\" style=\".*\">\\s*<table id=\"background-table\"";
    protected MailService mailService;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void createMailService() {
        this.mailService = new MailService(this.logger);
    }

    @After
    public void stopMailService() {
        this.flushMailQueue();
        this.mailService.stop();
    }

    protected void configureAndStartSmtpServer() {
        this.configureAndStartMailServers(DEFAULT_FROM_ADDRESS, DEFAULT_SUBJECT_PREFIX, JIRAServerSetup.SMTP);
    }

    protected void configureAndStartImapServer() {
        this.configureAndStartMailServers(DEFAULT_FROM_ADDRESS, DEFAULT_SUBJECT_PREFIX, JIRAServerSetup.IMAP);
    }

    protected void configureAndStartSmtpServer(String from, String prefix) {
        this.configureAndStartMailServers(from, prefix, JIRAServerSetup.SMTP);
    }

    protected void configureAndStartMailServers(String from, String prefix, JIRAServerSetup ... jiraServerSetups) {
        this.assertSendingMailIsEnabled();
        this.startMailService(jiraServerSetups);
        List<JIRAServerSetup> serverSetupList = Arrays.asList(jiraServerSetups);
        if (serverSetupList.contains((Object)JIRAServerSetup.IMAP)) {
            int imapPort = this.mailService.getImapPort();
            this.logger.log((Object)("Setting IMAP server to 'localhost:" + imapPort + "'"));
            this.backdoor.mailServers().addPopServer("Local Test Imap Server", "Imap Server for test purposes", "imap", "localhost", imapPort, "admin", "admin");
        }
        if (serverSetupList.contains((Object)JIRAServerSetup.POP3)) {
            int popPort = this.mailService.getPop3Port();
            this.logger.log((Object)("Setting POP3 server to 'localhost:" + popPort + "'"));
            this.backdoor.mailServers().addPopServer("Local Test Pop Server", "Pop Server for test purposes", "pop3", "localhost", popPort, "admin", "admin");
        }
        if (serverSetupList.contains((Object)JIRAServerSetup.SMTP)) {
            int smtpPort = this.mailService.getSmtpPort();
            this.logger.log((Object)("Setting SMTP server to 'localhost:" + smtpPort + "'"));
            this.backdoor.mailServers().addSmtpServer(from, prefix, smtpPort);
        }
    }

    protected void configureAndStartSmtpServerWithNotify() {
        this.configureAndStartSmtpServer();
        this.navigation.userProfile().changeNotifyMyChanges(true);
    }

    protected void startMailService(JIRAServerSetup ... jiraServerSetups) {
        try {
            this.mailService.configureAndStartGreenMail(jiraServerSetups);
        }
        catch (BindException e) {
            Assert.fail((String)"Error: Could not start green mail server. See log for details.");
        }
    }

    protected Collection<String> parseEmailAddresses(String emails) {
        StringTokenizer st = new StringTokenizer(emails, ",");
        ArrayList<String> emailList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String email = st.nextToken().trim();
            if (!TextUtils.stringSet((String)email)) continue;
            emailList.add(email.trim());
        }
        return emailList;
    }

    protected void assertRecipientsHaveMessages(Collection<String> recipients) throws MessagingException {
        for (String recipient : recipients) {
            MatcherAssert.assertThat(this.getMessagesForRecipient(recipient), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        }
    }

    protected List<MimeMessage> getMessagesForRecipient(String recipient) throws MessagingException {
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        ArrayList<MimeMessage> ret = new ArrayList<MimeMessage>();
        for (MimeMessage message : messages) {
            if (!Arrays.asList(message.getHeader("To")).contains(recipient)) continue;
            ret.add(message);
        }
        return ret;
    }

    protected void assertSendingMailIsEnabled() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.MAIL_QUEUE);
        try {
            String responseText = this.tester.getDialog().getResponse().getText();
            if (responseText.contains("Sending mail is disabled")) {
                Assert.fail((String)"Mail sending is disabled. Please restart your server without -Datlassian.mail.senddisabled=true.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupJiraImapPopServer() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.INCOMING_MAIL);
        this.tester.clickLinkWithText("Add POP / IMAP mail server");
        this.tester.setFormElement("name", "Local Test Pop/Imap Server");
        this.tester.setFormElement("serverName", "localhost");
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.submit("Add");
    }

    protected void setupPopService() {
        this.setupPopService("project=MKY, issue=1, createusers=true, issuetype=1");
    }

    protected void setupPopService(String handlerParameters) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
        this.tester.setFormElement("name", "pop");
        this.tester.setFormElement("clazz", "com.atlassian.jira.service.services.mail.MailFetcherService");
        this.tester.setFormElement("service.schedule.cronString", "0 0 * * * ?");
        this.tester.submit("Add Service");
        this.tester.setFormElement("handler.params", handlerParameters);
        this.tester.setFormElement("service.schedule.cronString", "0 0 * * * ?");
        this.tester.submit("Update");
    }

    protected void setupImapService() {
        this.setupImapService(false);
    }

    protected void setupImapService(boolean markAsSeen) {
        this.setupImapService("project=MKY, issue=1, createusers=true, issuetype=1", markAsSeen);
    }

    protected void setupImapService(String handlerParameters, boolean markAsSeen) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
        this.tester.setFormElement("name", "imap");
        this.tester.setFormElement("clazz", "com.atlassian.jira.service.services.mail.MailFetcherService");
        this.tester.setFormElement("service.schedule.cronString", "0 0 * * * ?");
        this.tester.submit("Add Service");
        this.tester.setFormElement("handler.params", handlerParameters);
        this.tester.setFormElement("service.schedule.cronString", "0 0 * * * ?");
        if (markAsSeen) {
            this.tester.setFormElement("markasseen", "true");
        }
        this.tester.submit("Update");
    }

    protected void flushMailQueueAndWait(int emailCount) throws InterruptedException {
        this.flushMailQueueAndWait(emailCount, 5000);
    }

    protected void flushMailQueueAndWait(int emailCount, int waitPeriodMillis) throws InterruptedException {
        this.flushMailQueue();
        this.logger.log((Object)("Flushed mail queue. Waiting for '" + waitPeriodMillis + "' ms..."));
        boolean receivedAllMail = this.mailService.waitForIncomingMessage(waitPeriodMillis, emailCount);
        if (!receivedAllMail) {
            this.failNotReceivedAllMail(emailCount);
        }
    }

    protected void flushMailQueueAndWaitForRecipients(int waitPeriodMillis, String ... recipientAddresses) throws InterruptedException, MessagingException {
        this.flushMailQueue();
        long start = System.currentTimeMillis();
        this.logger.log((Object)("Flushed mail queue. Waiting for '" + waitPeriodMillis + "' ms..."));
        boolean receivedAllMail = this.mailService.waitForIncomingMessage(waitPeriodMillis, recipientAddresses.length);
        long waited = System.currentTimeMillis() - start;
        long remainder = (long)waitPeriodMillis - waited;
        if (!receivedAllMail) {
            this.failNotReceivedAllMail(recipientAddresses.length);
        }
        HashSet remainingRecipients = Sets.newHashSetWithExpectedSize((int)recipientAddresses.length);
        remainingRecipients.addAll(Arrays.asList(recipientAddresses));
        while (remainder > 0L && !remainingRecipients.isEmpty()) {
            MimeMessage[] receivedMessages;
            start = System.currentTimeMillis();
            for (MimeMessage message : receivedMessages = this.mailService.getReceivedMessages()) {
                String[] tos = message.getHeader("To");
                remainingRecipients.removeAll(Arrays.asList(tos));
            }
            if (remainingRecipients.isEmpty()) {
                return;
            }
            this.mailService.waitForIncomingMessage(remainder, receivedMessages.length + 1);
            waited = System.currentTimeMillis() - start;
            remainder -= waited;
        }
        String msg = "Did not receive emails for all recipients (" + StringUtils.join((Object[])recipientAddresses, (String)", ") + ") within the timeout.";
        MimeMessage[] receivedMessages = this.mailService.getReceivedMessages();
        if (receivedMessages != null) {
            if (receivedMessages.length > 0) {
                msg = msg + "\n  Recipients: " + this.display(receivedMessages);
            }
        } else {
            msg = msg + " Received zero messages.";
        }
        Assert.fail((String)msg);
    }

    private void failNotReceivedAllMail(int emailCount) {
        String msg = "Did not receive all expected emails (" + emailCount + ") within the timeout.";
        MimeMessage[] receivedMessages = this.mailService.getReceivedMessages();
        if (receivedMessages != null) {
            msg = msg + " Only received " + receivedMessages.length + " message(s).";
            if (receivedMessages.length > 0) {
                msg = msg + "\n  Recipients: " + this.display(receivedMessages);
            }
        } else {
            msg = msg + " Received zero messages.";
        }
        Assert.fail((String)msg);
    }

    protected void flushMailQueue() {
        this.backdoor.mailServers().flushMailQueue();
    }

    private String display(MimeMessage[] receivedMessages) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < receivedMessages.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            MimeMessage receivedMessage = receivedMessages[i];
            try {
                sb.append(receivedMessage.getRecipients(Message.RecipientType.TO)[0]);
                continue;
            }
            catch (MessagingException e) {
                sb.append("???");
            }
        }
        return sb.toString();
    }

    protected void waitForMail(int emailCount) throws InterruptedException {
        int waitPeriodMillis = 500;
        Assert.assertTrue((String)"Did not recieve all expected emails within the timeout", (boolean)this.mailService.waitForIncomingMessage(500L, emailCount));
    }

    protected void assertEmailBodyContains(MimeMessage email, String bodySubString) throws MessagingException, IOException {
        String emailBody = GreenMailUtil.getBody((Part)email);
        Assert.assertTrue((String)("The string '" + bodySubString + "' was not found in the e-mail body [" + emailBody + "]"), (boolean)emailBody.contains(bodySubString));
    }

    protected void assertEmailBodyContainsLine(MimeMessage email, String ... linePattern) {
        int missingLinePatternIdx = this.getMissingLinePattern(email, linePattern);
        if (missingLinePatternIdx != -1) {
            Assert.fail((String)("The line '" + linePattern[missingLinePatternIdx] + "' was not found in the e-mail body [" + this.decodeQuotedPrintableBody(email) + "]"));
        }
    }

    private int getMissingLinePattern(MimeMessage email, String ... linePattern) {
        String emailBody = this.decodeQuotedPrintableBody(email);
        String[] lines = emailBody.split("\\n");
        int linePatternIdx = 0;
        for (String line : lines) {
            if (line.trim().matches(linePattern[linePatternIdx])) {
                ++linePatternIdx;
            }
            if (linePatternIdx < linePattern.length) continue;
            return -1;
        }
        return linePatternIdx;
    }

    protected void assertEmailReceivedWithBodyContainingLine(int expectedMatchingEmailsCount, Collection<MimeMessage> emails, String ... linePattern) {
        long matchingEmails = emails.stream().filter(email -> this.getMissingLinePattern((MimeMessage)email, linePattern) == -1).count();
        if ((long)expectedMatchingEmailsCount != matchingEmails) {
            String unmatchedEmails = emails.stream().filter(email -> this.getMissingLinePattern((MimeMessage)email, linePattern) != -1).map(this::decodeQuotedPrintableBody).collect(Collectors.joining("\n---------\n"));
            String msg = String.format("Expected %d emails to match match the given pattern but only %d matches found\nPattern: %s\nEmails not matching the pattern:\n %s", expectedMatchingEmailsCount, matchingEmails, Arrays.toString(linePattern), unmatchedEmails);
            Assert.fail((String)msg);
        }
    }

    protected void assertEmailBodyDoesntContain(MimeMessage email, String bodySubString) throws MessagingException, IOException {
        String emailBody = GreenMailUtil.getBody((Part)email);
        Assert.assertTrue((String)("The string '" + bodySubString + "' was found (shouldn't exist) in the e-mail body [" + emailBody + "]"), (!emailBody.contains(bodySubString) ? 1 : 0) != 0);
    }

    protected void assertEmailBodyContains(String emailBody, String bodySubString) throws MessagingException, IOException {
        Assert.assertTrue((String)("Expected '" + bodySubString + "' to be present in email body '" + emailBody + "'"), (boolean)emailBody.contains(bodySubString));
    }

    protected void assertEmailHasNumberOfParts(MimeMessage email, int expectedNumOfParts) throws MessagingException, IOException {
        Object emailContent = email.getContent();
        if (emailContent instanceof Multipart) {
            Multipart multiPart = (Multipart)emailContent;
            Assert.assertEquals((long)expectedNumOfParts, (long)multiPart.getCount());
        } else {
            Assert.fail((String)"Cannot assert number of parts for email. Email is not a multipart type.");
        }
    }

    protected void assertEmailToEquals(MimeMessage email, String expectedTo) throws MessagingException {
        this.assertEmailToEquals(email, this.parseEmailAddresses(expectedTo));
    }

    protected void assertEmailToEquals(MimeMessage email, Collection<?> expectedToAddresses) throws MessagingException {
        String[] toHeader = email.getHeader("to");
        MatcherAssert.assertThat((Object)toHeader.length, (Matcher)Matchers.equalTo((Object)1));
        Collection<String> actualAddresses = this.parseEmailAddresses(toHeader[0]);
        this.assertEmailsEquals(expectedToAddresses, actualAddresses);
    }

    protected void assertEmailCcEquals(MimeMessage email, Collection<?> expectedCcAddresses) throws MessagingException {
        String[] ccHeader = email.getHeader("cc");
        if (ccHeader != null) {
            MatcherAssert.assertThat((Object)ccHeader.length, (Matcher)Matchers.equalTo((Object)1));
            Collection<String> actualAddresses = this.parseEmailAddresses(ccHeader[0]);
            this.assertEmailsEquals(expectedCcAddresses, actualAddresses);
        } else {
            MatcherAssert.assertThat(expectedCcAddresses, (Matcher)Matchers.empty());
        }
    }

    private void assertEmailsEquals(Collection expectedAddresses, Collection actualAddresses) {
        Assert.assertEquals((Object)expectedAddresses, (Object)actualAddresses);
    }

    protected void assertEmailFromEquals(MimeMessage email, String expectedTo) throws MessagingException {
        String[] addresses = email.getHeader("from");
        MatcherAssert.assertThat(Arrays.asList(addresses), (Matcher)Matchers.contains((Object[])new String[]{expectedTo}));
    }

    protected void assertEmailSubjectEquals(MimeMessage email, String subject) throws MessagingException {
        Assert.assertEquals((Object)subject, (Object)email.getSubject());
    }

    protected void assertEmailSent(String recipient, String subject, String issueComment) throws MessagingException, IOException {
        List<MimeMessage> emails = this.getMessagesForRecipient(recipient);
        Assert.assertEquals((String)("Incorrect number of e-mails received for '" + recipient + "'"), (long)1L, (long)emails.size());
        MimeMessage emailMessage = emails.get(0);
        this.assertEmailBodyContains(emailMessage, issueComment);
        this.assertEmailSubjectEquals(emailMessage, subject);
    }

    protected void assertCorrectNumberEmailsSent(int numOfMessages) throws MessagingException {
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        if (messages.length != numOfMessages) {
            for (MimeMessage message : messages) {
                this.logger.log((Object)("Mail sent to '" + message.getHeader("to")[0] + "' with SUBJECT '" + message.getSubject() + "'"));
            }
            Assert.fail((String)("Invalid number of e-mails received.  Was " + messages.length + " but should have been " + numOfMessages + "."));
        }
    }

    protected final MailBox getMailBox(String email) throws FolderException {
        return new MailBox(this.mailService.getUserInbox(email), email);
    }

    private String decodeQuotedPrintableBody(MimeMessage message) {
        String body = GreenMailUtil.getBody((Part)message);
        try {
            Object[] headersArray = message.getHeader("Content-Transfer-Encoding");
            HashSet headers = Sets.newHashSet((Object[])(headersArray == null ? new String[]{} : headersArray));
            if (headers.contains("quoted-printable")) {
                InputStream inputStream = MimeUtility.decode((InputStream)new ByteArrayInputStream(body.getBytes()), (String)"quoted-printable");
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                body = IOUtils.toString((Reader)reader);
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return body;
    }

    protected final void assertMessageAndType(MimeMessage message, String expectedComment, boolean html) {
        String body = this.decodeQuotedPrintableBody(message);
        if (html) {
            MatcherAssert.assertThat((Object)body, (Matcher)RegexMatchers.regexMatches((String)HTML_FORMAT_REGEX));
        } else {
            MatcherAssert.assertThat((Object)body, (Matcher)RegexMatchers.regexMatchesNot((String)HTML_FORMAT_REGEX));
        }
        this.textAssertions.assertTextSequence(body, expectedComment, new String[0]);
    }

    protected final void assertNotMessageAndType(MimeMessage message, String expectedComment, boolean html) {
        String body = GreenMailUtil.getBody((Part)message);
        if (html) {
            MatcherAssert.assertThat((Object)body, (Matcher)RegexMatchers.regexMatches((String)HTML_FORMAT_REGEX));
        } else {
            MatcherAssert.assertThat((Object)body, (Matcher)RegexMatchers.regexMatchesNot((String)HTML_FORMAT_REGEX));
        }
        this.textAssertions.assertTextNotPresent(body, expectedComment);
    }

    public static TypeSafeMatcher<MimeMessage> hasBody(final Matcher<String> bodyMatcher) {
        return new TypeSafeMatcher<MimeMessage>(){

            protected boolean matchesSafely(MimeMessage email) {
                String emailBody = GreenMailUtil.getBody((Part)email);
                return bodyMatcher.matches((Object)emailBody);
            }

            public void describeTo(Description description) {
                description.appendText("Email body that matches ");
                bodyMatcher.describeTo(description);
            }
        };
    }

    protected static final class MailBox {
        private final MailFolder folder;
        private final String userEmail;
        private int pos;

        public MailBox(MailFolder folder, String userEmail) {
            this.folder = folder;
            this.userEmail = userEmail;
        }

        public MimeMessage nextMessage() {
            List<StoredMessage> messages = this.getMessages();
            if (this.pos >= messages.size()) {
                return null;
            }
            return messages.get(this.pos++).getMimeMessage();
        }

        private List<StoredMessage> getMessages() {
            return this.folder.getMessages();
        }

        public int size() {
            return this.folder.getMessageCount();
        }

        public void clear() {
            this.folder.deleteAllMessages();
            this.pos = 0;
        }

        public MimeMessage awaitMessage() {
            return this.awaitMessage(1000L);
        }

        public MimeMessage awaitMessage(long timeout) {
            MimeMessage message = this.nextMessage();
            long startTime = System.currentTimeMillis();
            if (message == null) {
                long timeoutTime = timeout + startTime;
                long currentTime = startTime;
                while (currentTime < timeoutTime && message == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    message = this.nextMessage();
                    currentTime = System.currentTimeMillis();
                }
            }
            if (message == null) {
                Assert.fail((String)("Waited '" + (System.currentTimeMillis() - startTime) + "' ms for e-mail to '" + this.userEmail + "' but got nothing."));
            }
            return message;
        }
    }
}

