/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST})
public class TestStaticFilesContentType
extends BaseJiraFuncTest {
    private FuncTestUrlHelper funcTestUrlHelper;
    private CloseableHttpClient client;

    @Before
    public void setUpTest() {
        this.funcTestUrlHelper = new FuncTestUrlHelper(this.environmentData);
        this.client = HttpClientBuilder.create().build();
    }

    @After
    public void tearDown() throws IOException {
        this.client.close();
    }

    @Test
    public void testRobotsTxtHasCorrectMimeType() throws IOException {
        HttpGet request = new HttpGet(this.funcTestUrlHelper.getBaseUrl() + "/robots.txt");
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        String mimeType = contentType.getMimeType();
        Assert.assertEquals((Object)"text/plain", (Object)mimeType);
    }
}

