/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.REFERENCE_PLUGIN})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestAdminMenuLinks
extends BaseJiraFuncTest {
    @Test
    public void testClickingLinkKeepsAdminContext() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.isAdminTab("System");
        this.tester.clickLink("reference-admin-servlet-link-from-system-tab");
        this.isAdminTab("System");
        this.isLinkSelected("Reference Admin Servlet System tab");
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIND_MORE_ADMIN_TOOLS);
        this.tester.clickLink("reference-admin-servlet-link-from-add-on-tab");
        this.isAdminTab("Manage apps");
        this.isLinkSelected("Reference Admin Servlet Add-on tab");
    }

    @Test
    public void testProjectAdminDoesNotHaveNavigationMenu() {
        this.goToProjectAdministrationSummary("HSP");
        this.assertions.assertNodeByIdDoesNotExist("admin-nav-heading");
    }

    public void goToProjectAdministrationSummary(String projectKey) {
        this.navigation.gotoPage("plugins/servlet/project-config/" + projectKey + "/summary");
    }

    private void isAdminTab(String tab) {
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-nav-selected"), tab);
    }

    private void isLinkSelected(String link) {
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-nav-selected"), link);
    }
}

