/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.atlassian.jira.testkit.client.restclient.AttachmentClient;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.CommentsWithPaginationBean;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueLink;
import com.atlassian.jira.testkit.client.restclient.LinkIssueClient;
import com.atlassian.jira.testkit.client.restclient.LinkRequest;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.Vote;
import com.atlassian.jira.testkit.client.restclient.VotesClient;
import com.atlassian.jira.testkit.client.restclient.WatchersClient;
import com.atlassian.jira.testkit.client.restclient.Watches;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES})
@LoginAs(user="admin")
public class TestAdminsWithoutAppRoles
extends BaseJiraFuncTest {
    private static final String JOHN_ADMIN = "john";
    private static final String JOHNS_ISSUE_KEY = "TWO-1";
    private static final String UNASSIGNED_ISSUE = "TWO-2";
    private static final String JOHNS_PROJECT = "TWO";
    private static final String OTHER_PROJECT = "ONE";
    private Comment adminsComment = new Comment();
    private Comment johnsComment = new Comment();
    private Worklog adminsWorklog = new Worklog();
    private Worklog johnsWorklog = new Worklog();
    private Attachment johnsAttachment = new Attachment();
    private Attachment adminsAttachment = new Attachment();
    private IssueClient client;
    private ProjectClient projectClient;
    private LinkIssueClient linkIssueClient;
    private WatchersClient watchersClient;
    private VotesClient votesClient;
    private CommentClient commentClient;
    private WorklogClient worklogClient;
    private AttachmentClient attachmentClient;
    private AttachFileClient attachFileClient;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    public TestAdminsWithoutAppRoles() {
        this.adminsWorklog.id = String.valueOf(10000);
        this.adminsWorklog.timeSpent = "2h";
        this.johnsWorklog.id = String.valueOf(10001);
        this.johnsWorklog.timeSpent = "4h";
        this.adminsComment.id = String.valueOf(10100);
        this.adminsComment.body = "Other Comment";
        this.johnsComment.id = String.valueOf(10000);
        this.johnsComment.body = "My Comment";
        this.johnsAttachment.id = String.valueOf(10000);
        this.johnsAttachment.filename = "Hello.txt";
        this.adminsAttachment.id = String.valueOf(10100);
        this.adminsAttachment.filename = "admin.txt";
    }

    private static <I, O> List<O> map(Collection<I> input, Function<? super I, ? extends O> func) {
        return (List)input.stream().map(func).collect(CollectorsUtil.toImmutableList());
    }

    private static <T> Matcher<Iterable<? extends T>> containsInAnyOrder(Collection<T> items) {
        return Matchers.containsInAnyOrder(TestAdminsWithoutAppRoles.map(items, Matchers::equalTo));
    }

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestAdminAccessNoAppRole.zip");
        this.client = (IssueClient)new IssueClient((JIRAEnvironmentData)this.environmentData).loginAs(JOHN_ADMIN);
        this.projectClient = (ProjectClient)new ProjectClient((JIRAEnvironmentData)this.environmentData).loginAs(JOHN_ADMIN);
        this.linkIssueClient = (LinkIssueClient)new LinkIssueClient((JIRAEnvironmentData)this.environmentData).loginAs(JOHN_ADMIN);
        this.commentClient = (CommentClient)new CommentClient((JIRAEnvironmentData)this.environmentData).loginAs(JOHN_ADMIN);
        this.worklogClient = (WorklogClient)new WorklogClient((JIRAEnvironmentData)this.environmentData).loginAs(JOHN_ADMIN);
        this.attachmentClient = (AttachmentClient)new AttachmentClient((JIRAEnvironmentData)this.environmentData).loginAs(JOHN_ADMIN);
        this.votesClient = (VotesClient)new VotesClient((JIRAEnvironmentData)this.environmentData).loginAs(JOHN_ADMIN);
        this.watchersClient = (WatchersClient)new WatchersClient((JIRAEnvironmentData)this.environmentData).loginAs(JOHN_ADMIN);
        this.attachFileClient = (AttachFileClient)new AttachFileClient(this.environmentData).loginAs(JOHN_ADMIN);
    }

    @Test
    public void testAdminWithoutApplicationCantSeeWatchersAndVoters() {
        this.votesClient.loginAs("admin");
        this.votesClient.postResponse(JOHNS_ISSUE_KEY);
        this.removeJohnFromSoftware();
        this.votesClient.loginAs(JOHN_ADMIN);
        ParsedResponse watchResponce = this.watchersClient.getResponse(JOHNS_ISSUE_KEY);
        MatcherAssert.assertThat((Object)watchResponce.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        ParsedResponse voteResponce = this.votesClient.getResponse(JOHNS_ISSUE_KEY);
        MatcherAssert.assertThat((Object)voteResponce.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        Watches watches = this.watchersClient.get(JOHNS_ISSUE_KEY);
        MatcherAssert.assertThat((Object)watches.watchCount, (Matcher)Matchers.is((Object)2L));
        Vote vote = this.votesClient.get(JOHNS_ISSUE_KEY);
        MatcherAssert.assertThat((Object)vote.votes, (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat(vote.voters.stream().map(user -> user.name).collect(CollectorsUtil.toImmutableList()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"admin"}));
    }

    @Test
    public void testAdminWithoutApplicationCantModifyWatchers() {
        this.removeJohnFromSoftware();
        ParsedResponse modifyWatchResponce = this.watchersClient.deleteResponse(JOHNS_ISSUE_KEY, "admin");
        MatcherAssert.assertThat((Object)modifyWatchResponce.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        modifyWatchResponce = this.watchersClient.deleteResponse(JOHNS_ISSUE_KEY, "admin");
        MatcherAssert.assertThat((Object)modifyWatchResponce.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
    }

    @Test
    public void testAdminWithoutApplicationCantModifyVoters() {
        this.addJohnToSoftware();
        this.votesClient.postResponse(UNASSIGNED_ISSUE);
        this.votesClient.get(UNASSIGNED_ISSUE);
        this.removeJohnFromSoftware();
        this.votesClient.loginAs(JOHN_ADMIN);
        ParsedResponse modifyVoteResponce = this.votesClient.deleteResponse(UNASSIGNED_ISSUE);
        MatcherAssert.assertThat((Object)modifyVoteResponce.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        modifyVoteResponce = this.votesClient.deleteResponse(UNASSIGNED_ISSUE);
        MatcherAssert.assertThat((Object)modifyVoteResponce.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
    }

    @Test
    public void testAdminWithoutApplicationCantVote() {
        this.removeJohnFromSoftware();
        this.votesClient.loginAs(JOHN_ADMIN);
        ParsedResponse modifyVoteResponce = this.votesClient.postResponse(UNASSIGNED_ISSUE);
        MatcherAssert.assertThat((Object)modifyVoteResponce.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        modifyVoteResponce = this.votesClient.postResponse(UNASSIGNED_ISSUE);
        MatcherAssert.assertThat((Object)modifyVoteResponce.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
    }

    @Test
    public void testAdminWithoutApplicationCantRemoveVote() {
        this.addJohnToSoftware();
        this.votesClient.postResponse(UNASSIGNED_ISSUE);
        this.votesClient.get(UNASSIGNED_ISSUE);
        this.removeJohnFromSoftware();
        this.votesClient.loginAs(JOHN_ADMIN);
        ParsedResponse modifyVoteResponce = this.votesClient.deleteResponse(UNASSIGNED_ISSUE);
        MatcherAssert.assertThat((Object)modifyVoteResponce.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        modifyVoteResponce = this.votesClient.deleteResponse(UNASSIGNED_ISSUE);
        MatcherAssert.assertThat((Object)modifyVoteResponce.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
    }

    @Test
    public void testAdminWithoutApplicationCantReadIssueThroughUI() {
        this.navigation.login(JOHN_ADMIN);
        this.navigation.issue().viewIssue(JOHNS_ISSUE_KEY);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }

    @Test
    public void testAdminWithoutApplicationCantReadIssue() {
        this.addJohnToSoftware();
        Issue issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.key, (Matcher)Matchers.equalTo((Object)JOHNS_ISSUE_KEY));
        this.removeJohnFromSoftware();
        ParsedResponse response = this.client.getResponse(JOHNS_ISSUE_KEY);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
    }

    @Test
    public void testAdminWithoutApplicationCantBeAssignedToIssue() {
        this.client.loginAs("admin");
        this.removeJohnFromSoftware();
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().assignee(ResourceRef.withName((String)JOHN_ADMIN)));
        ParsedResponse updateResponse = this.client.updateResponse(UNASSIGNED_ISSUE, updateSummaryRequest);
        MatcherAssert.assertThat((Object)updateResponse.statusCode, (Matcher)Matchers.is((Object)HttpStatus.BAD_REQUEST.code));
        Issue issue = this.client.get(UNASSIGNED_ISSUE, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.assignee, (Matcher)Matchers.nullValue());
        this.addJohnToSoftware();
        updateResponse = this.client.updateResponse(UNASSIGNED_ISSUE, updateSummaryRequest);
        MatcherAssert.assertThat((Object)updateResponse.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        issue = this.client.get(UNASSIGNED_ISSUE, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.assignee.name, (Matcher)Matchers.equalTo((Object)JOHN_ADMIN));
    }

    @Test
    public void testAdminWithoutApplicationCantAssignIssue() {
        this.removeJohnFromSoftware();
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().assignee(ResourceRef.withName((String)"admin")));
        ParsedResponse updateResponse = this.client.updateResponse(JOHNS_ISSUE_KEY, updateSummaryRequest);
        MatcherAssert.assertThat((Object)updateResponse.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        Issue issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.assignee.name, (Matcher)Matchers.equalTo((Object)JOHN_ADMIN));
        updateResponse = this.client.updateResponse(JOHNS_ISSUE_KEY, updateSummaryRequest);
        MatcherAssert.assertThat((Object)updateResponse.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.assignee.name, (Matcher)Matchers.equalTo((Object)"admin"));
    }

    @Test
    public void testAdminWithoutApplicationCantAssignIssueUI() {
        this.navigation.login(JOHN_ADMIN);
        this.tester.gotoPage("/secure/AssignIssue!default.jspa?id=10100");
        MatcherAssert.assertThat((Object)this.locator.id("assign-error").exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAdminWithoutApplicationCantCreateIssue() {
        this.removeJohnFromSoftware();
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        issueUpdateRequest.fields(new IssueFields().issueType(ResourceRef.withName((String)"Task")).project(ResourceRef.withKey((String)JOHNS_PROJECT)));
        ParsedResponse createResponse = this.client.getResponse(issueUpdateRequest);
        MatcherAssert.assertThat((Object)createResponse.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        String summary = "Create issue";
        String priority = "Medium";
        issueUpdateRequest.fields().summary("Create issue").priority(ResourceRef.withName((String)"Medium"));
        IssueCreateResponse goodCreateResponse = this.client.create(issueUpdateRequest);
        Issue issue = this.client.get(goodCreateResponse.key, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.summary, (Matcher)Matchers.equalTo((Object)"Create issue"));
        MatcherAssert.assertThat((Object)issue.fields.priority.name(), (Matcher)Matchers.equalTo((Object)"Medium"));
    }

    @Test
    public void testAdminWithoutApplicationCantDeleteIssue() {
        this.removeJohnFromSoftware();
        ParsedResponse response = this.client.delete(JOHNS_ISSUE_KEY, null);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        Issue issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.key, (Matcher)Matchers.equalTo((Object)JOHNS_ISSUE_KEY));
        response = this.client.delete(JOHNS_ISSUE_KEY, null);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        response = this.client.getResponse(JOHNS_ISSUE_KEY);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NOT_FOUND.code));
    }

    @Test
    public void testAdminWithoutApplicationCantEditIssue() {
        String oldSummary = "John's own task";
        String newSummary = "This is the new description";
        this.removeJohnFromSoftware();
        IssueUpdateRequest request = new IssueUpdateRequest().fields(new IssueFields());
        request.fields().summary("This is the new description");
        ParsedResponse response = this.client.updateResponse(JOHNS_ISSUE_KEY, request);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        Issue issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.summary, (Matcher)Matchers.equalTo((Object)"John's own task"));
        response = this.client.updateResponse(JOHNS_ISSUE_KEY, request);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.summary, (Matcher)Matchers.equalTo((Object)"This is the new description"));
    }

    @Test
    public void testAdminWithoutApplicationCantLinkIssue() {
        String linkTypeName = "Blocks";
        LinkRequest linkRequest = new LinkRequest().inwardIssue(ResourceRef.withKey((String)JOHNS_ISSUE_KEY)).outwardIssue(ResourceRef.withKey((String)UNASSIGNED_ISSUE)).type(ResourceRef.withName((String)"Blocks"));
        this.removeJohnFromSoftware();
        ParsedResponse response = this.linkIssueClient.linkIssues(linkRequest);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NOT_FOUND.code));
        this.addJohnToSoftware();
        Issue issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.issuelinks.isEmpty(), (Matcher)Matchers.equalTo((Object)true));
        response = this.linkIssueClient.linkIssues(linkRequest);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.CREATED.code));
        issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.issuelinks.size(), (Matcher)Matchers.equalTo((Object)1));
        IssueLink issueLink = (IssueLink)issue.fields.issuelinks.get(0);
        MatcherAssert.assertThat((Object)issueLink.inwardIssue(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)issueLink.outwardIssue().key(), (Matcher)Matchers.equalTo((Object)UNASSIGNED_ISSUE));
        MatcherAssert.assertThat((Object)issueLink.type().name(), (Matcher)Matchers.equalTo((Object)"Blocks"));
    }

    @Test
    public void testAdminWithoutApplicationCantModifyReporters() {
        this.removeJohnFromSoftware();
        IssueUpdateRequest request = new IssueUpdateRequest().fields(new IssueFields());
        request.fields().reporter(ResourceRef.withName((String)"admin"));
        ParsedResponse response = this.client.updateResponse(JOHNS_ISSUE_KEY, request);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        Issue issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.reporter.name, (Matcher)Matchers.equalTo((Object)JOHN_ADMIN));
        response = this.client.updateResponse(JOHNS_ISSUE_KEY, request);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.reporter.name, (Matcher)Matchers.equalTo((Object)"admin"));
    }

    @Test
    public void testAdminWithoutApplicationCantResolveIssue() {
        this.assertTransition(21, "To Do", "Done");
    }

    @Test
    public void testAdminWithoutApplicationCantScheduleIssue() {
        String dueDate = "2030-01-01";
        this.removeJohnFromSoftware();
        IssueUpdateRequest request = new IssueUpdateRequest().fields(new IssueFields());
        request.fields().dueDate("2030-01-01");
        ParsedResponse response = this.client.updateResponse(JOHNS_ISSUE_KEY, request);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        Issue issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.duedate, (Matcher)Matchers.nullValue());
        response = this.client.updateResponse(JOHNS_ISSUE_KEY, request);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.duedate, (Matcher)Matchers.equalTo((Object)"2030-01-01"));
    }

    @Test
    public void testAdminWithoutApplicationCantSetIssueSecurity() {
        String securityLevel = "Secret";
        this.removeJohnFromSoftware();
        IssueUpdateRequest request = new IssueUpdateRequest().fields(new IssueFields());
        request.fields().securityLevel(ResourceRef.withName((String)"Secret"));
        ParsedResponse response = this.client.updateResponse(JOHNS_ISSUE_KEY, request);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        Issue issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.security, (Matcher)Matchers.nullValue());
        response = this.client.updateResponse(JOHNS_ISSUE_KEY, request);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.security.name, (Matcher)Matchers.equalTo((Object)"Secret"));
    }

    @Test
    public void testAdminWithoutApplicationCantTransitionIssue() {
        this.assertTransition(71, "To Do", "Other Status");
    }

    @Test
    public void testAdminWithoutApplicationCantCloseIssue() {
        this.assertTransition(81, "To Do", "Closed");
    }

    @Test
    public void testViewProjectsAllowedForAdmin() {
        this.removeJohnFromSoftware();
        List collect = (List)this.projectClient.getProjects().stream().map(p -> p.key).collect(CollectorsUtil.toImmutableList());
        MatcherAssert.assertThat((Object)collect, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{JOHNS_PROJECT, OTHER_PROJECT}));
        Project project = this.projectClient.get(JOHNS_PROJECT);
        MatcherAssert.assertThat((Object)project.key, (Matcher)Matchers.equalTo((Object)JOHNS_PROJECT));
        project = this.projectClient.get(OTHER_PROJECT);
        MatcherAssert.assertThat((Object)project.key, (Matcher)Matchers.equalTo((Object)OTHER_PROJECT));
    }

    @Test
    public void testAdminWithoutApplicationCantComment() {
        this.removeJohnFromSoftware();
        Comment newComment = new Comment();
        newComment.body = "Something";
        this.commentClient.post(JOHNS_ISSUE_KEY, newComment);
        ParsedResponse response = this.commentClient.post(JOHNS_ISSUE_KEY, newComment);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertComments(this.johnsComment, this.adminsComment);
        response = this.commentClient.post(JOHNS_ISSUE_KEY, newComment);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.CREATED.code));
        this.assertComments(this.johnsComment, newComment, this.adminsComment);
    }

    @Test
    public void testAdminWithoutApplicationCantDeleteOwnComment() {
        this.removeJohnFromSoftware();
        ParsedResponse response = this.commentClient.delete(JOHNS_ISSUE_KEY, this.johnsComment.id);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertComments(this.johnsComment, this.adminsComment);
        response = this.commentClient.delete(JOHNS_ISSUE_KEY, this.johnsComment.id);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        this.assertComments(this.adminsComment);
    }

    @Test
    public void testAdminWithoutApplicationCantDeleteOtherComments() {
        this.removeJohnFromSoftware();
        ParsedResponse response = this.commentClient.delete(JOHNS_ISSUE_KEY, this.adminsComment.id);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertComments(this.johnsComment, this.adminsComment);
        response = this.commentClient.delete(JOHNS_ISSUE_KEY, this.adminsComment.id);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        this.assertComments(this.johnsComment);
    }

    @Test
    public void testAdminWithoutApplicationCantEditOwnComment() {
        this.removeJohnFromSoftware();
        Comment editedComment = new Comment();
        editedComment.id = this.johnsComment.id;
        editedComment.body = "Something";
        ParsedResponse response = this.commentClient.put(JOHNS_ISSUE_KEY, editedComment);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertComments(this.johnsComment, this.adminsComment);
        response = this.commentClient.put(JOHNS_ISSUE_KEY, editedComment);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.OK.code));
        MatcherAssert.assertThat((Object)((Comment)response.body).body, (Matcher)Matchers.equalTo((Object)editedComment.body));
        this.assertComments(editedComment, this.adminsComment);
    }

    @Test
    public void testAdminWithoutApplicationCantEditOtherComment() {
        String newBody = "New Body";
        Comment otherComment = new Comment();
        otherComment.body = "New Body";
        otherComment.id = this.adminsComment.id;
        this.removeJohnFromSoftware();
        ParsedResponse response = this.commentClient.put(JOHNS_ISSUE_KEY, otherComment);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertComments(this.adminsComment, this.johnsComment);
        response = this.commentClient.put(JOHNS_ISSUE_KEY, otherComment);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.OK.code));
        MatcherAssert.assertThat((Object)((Comment)response.body).body, (Matcher)Matchers.equalTo((Object)"New Body"));
        this.assertComments(this.johnsComment, otherComment);
    }

    @Test
    public void testAdminWithoutApplicationCantDeleteOwnWorklogs() {
        this.removeJohnFromSoftware();
        ParsedResponse response = this.worklogClient.delete(JOHNS_ISSUE_KEY, this.johnsWorklog);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertWorklogs(this.johnsWorklog, this.adminsWorklog);
        response = this.worklogClient.delete(JOHNS_ISSUE_KEY, this.johnsWorklog);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        this.assertWorklogs(this.adminsWorklog);
    }

    @Test
    public void testAdminWithoutApplicationCantDeleteOtherWorklogs() {
        this.removeJohnFromSoftware();
        ParsedResponse response = this.worklogClient.delete(JOHNS_ISSUE_KEY, this.adminsWorklog);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertWorklogs(this.johnsWorklog, this.adminsWorklog);
        response = this.worklogClient.delete(JOHNS_ISSUE_KEY, this.adminsWorklog);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        this.assertWorklogs(this.johnsWorklog);
    }

    @Test
    public void testAdminWithoutApplicationCantEditOwnWorklogs() {
        Worklog log = new Worklog();
        log.id = this.johnsWorklog.id;
        log.timeSpent = "1h";
        this.removeJohnFromSoftware();
        ParsedResponse response = this.worklogClient.put(JOHNS_ISSUE_KEY, this.johnsWorklog);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertWorklogs(this.johnsWorklog, this.adminsWorklog);
        response = this.worklogClient.put(JOHNS_ISSUE_KEY, log);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.OK.code));
        this.assertWorklogs(this.adminsWorklog, log);
    }

    @Test
    public void testAdminWithoutApplicationCantEditOtherWorklogs() {
        Worklog log = new Worklog();
        log.id = this.adminsWorklog.id;
        log.timeSpent = "1h";
        this.removeJohnFromSoftware();
        ParsedResponse response = this.worklogClient.put(JOHNS_ISSUE_KEY, this.adminsWorklog);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertWorklogs(this.johnsWorklog, this.adminsWorklog);
        response = this.worklogClient.put(JOHNS_ISSUE_KEY, log);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.OK.code));
        this.assertWorklogs(this.johnsWorklog, log);
    }

    @Test
    public void testAdminWithoutApplicationCantLogWork() {
        Worklog log = new Worklog();
        log.timeSpent = "1h";
        this.removeJohnFromSoftware();
        ParsedResponse response = this.worklogClient.post(JOHNS_ISSUE_KEY, this.adminsWorklog);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertWorklogs(this.johnsWorklog, this.adminsWorklog);
        response = this.worklogClient.post(JOHNS_ISSUE_KEY, log);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.CREATED.code));
        this.assertWorklogs(this.johnsWorklog, log, this.adminsWorklog);
    }

    @Test
    public void testAdminWithoutApplicationCantDeleteOwnAttachments() {
        this.removeJohnFromSoftware();
        ParsedResponse response = this.attachmentClient.deleteResponse(this.johnsAttachment.id);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertAttachments(this.johnsAttachment, this.adminsAttachment);
        response = this.attachmentClient.deleteResponse(this.johnsAttachment.id);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.NO_CONTENT.code));
        this.assertAttachments(this.adminsAttachment);
    }

    @Test
    public void testAdminWithoutApplicationCantDeleteOtherAttachments() {
        this.removeJohnFromSoftware();
        ParsedResponse response = this.attachmentClient.deleteResponse(this.adminsAttachment.id);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertAttachments(this.johnsAttachment, this.adminsAttachment);
        response = this.attachmentClient.deleteResponse(this.adminsAttachment.id);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.NO_CONTENT.code));
        this.assertAttachments(this.johnsAttachment);
    }

    @Test
    public void testAdminWithoutApplicationCantCreateAttachments() {
        Attachment attachment = new Attachment();
        attachment.filename = "hack.txt";
        this.removeJohnFromSoftware();
        ParsedResponse<List<Attachment>> response = this.attachFileClient.attachData(JOHNS_ISSUE_KEY, "hello hack", attachment.filename);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        this.assertAttachments(this.johnsAttachment, this.adminsAttachment);
        response = this.attachFileClient.attachData(JOHNS_ISSUE_KEY, "hello hack", attachment.filename);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.OK.code));
        this.assertAttachments(this.johnsAttachment, this.adminsAttachment, attachment);
    }

    @Test
    public void testAdminWithoutApplicationCantMoveIssuesUI() {
        this.navigation.login(JOHN_ADMIN);
        this.removeJohnFromSoftware();
        this.tester.gotoPage("/secure/MoveIssue!default.jspa?id=10100");
        MatcherAssert.assertThat((Object)this.locator.id("move-error").exists(), (Matcher)Matchers.is((Object)true));
        this.addJohnToSoftware();
        this.tester.gotoPage("/secure/MoveIssue!default.jspa?id=10100");
        MatcherAssert.assertThat((Object)this.locator.id("move-error").exists(), (Matcher)Matchers.is((Object)false));
    }

    private void assertTransition(int transitionId, String currentStatus, String targetStatus) {
        this.removeJohnFromSoftware();
        IssueUpdateRequest request = new IssueUpdateRequest().fields(new IssueFields());
        request.transition(ResourceRef.withId((String)String.valueOf(transitionId)));
        ParsedResponse response = this.client.transition(JOHNS_ISSUE_KEY, request);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.FORBIDDEN.code));
        this.addJohnToSoftware();
        Issue issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.status.name(), (Matcher)Matchers.equalTo((Object)currentStatus));
        response = this.client.transition(JOHNS_ISSUE_KEY, request);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)HttpStatus.NO_CONTENT.code));
        issue = this.client.get(JOHNS_ISSUE_KEY, new Issue.Expand[0]);
        MatcherAssert.assertThat((Object)issue.fields.status.name(), (Matcher)Matchers.equalTo((Object)targetStatus));
    }

    private void assertComments(Comment ... bodies) {
        List<String> actualBodies = TestAdminsWithoutAppRoles.map(((CommentsWithPaginationBean)this.commentClient.getComments((String)JOHNS_ISSUE_KEY).body).getComments(), c -> c.body);
        List<String> expectedBodies = TestAdminsWithoutAppRoles.map(Arrays.asList(bodies), c -> c.body);
        MatcherAssert.assertThat(actualBodies, TestAdminsWithoutAppRoles.containsInAnyOrder(expectedBodies));
    }

    private void assertWorklogs(Worklog ... logs) {
        List<String> actualTimes = TestAdminsWithoutAppRoles.map(this.worklogClient.getAll((String)JOHNS_ISSUE_KEY).worklogs, c -> c.timeSpent);
        List<String> expectedTimes = TestAdminsWithoutAppRoles.map(Arrays.asList(logs), c -> c.timeSpent);
        MatcherAssert.assertThat(actualTimes, TestAdminsWithoutAppRoles.containsInAnyOrder(expectedTimes));
    }

    private void assertAttachments(Attachment ... attachments) {
        List<String> actualNames = TestAdminsWithoutAppRoles.map(this.client.get((String)JOHNS_ISSUE_KEY, (Issue.Expand[])new Issue.Expand[0]).fields.attachment, c -> c.filename);
        List<String> expectedNames = TestAdminsWithoutAppRoles.map(Arrays.asList(attachments), c -> c.filename);
        MatcherAssert.assertThat(actualNames, TestAdminsWithoutAppRoles.containsInAnyOrder(expectedNames));
    }

    private void addJohnToSoftware() {
        this.backdoor.applicationRoles().putRole("jira-software", "jira-administrators", "other-admin");
    }

    private void removeJohnFromSoftware() {
        this.backdoor.applicationRoles().putRole("jira-software", "jira-administrators");
    }

    private static class AttachFileClient
    extends RestApiClient<AttachFileClient> {
        private static final GenericType<List<Attachment>> ATTACHMENT_LIST = new GenericType<List<Attachment>>(){};

        private AttachFileClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
        }

        public ParsedResponse<List<Attachment>> attachData(String issue, String data, String name) {
            return this.toResponse(() -> {
                FormDataContentDisposition contentDisposition = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"file").fileName(name)).size((long)data.length())).build();
                FormDataBodyPart formPart = new FormDataBodyPart("file", data);
                formPart.setFormDataContentDisposition(contentDisposition);
                MultiPart file = new MultiPart(MediaType.MULTIPART_FORM_DATA_TYPE).bodyPart((BodyPart)formPart);
                return (Response)((WebTarget)this.createResource().register(MultiPartFeature.class)).path("issue").path(issue).path("attachments").request(new MediaType[]{MediaType.MULTIPART_FORM_DATA_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Atlassian-Token", (Object)"no-check").post(Entity.entity((Object)file, (MediaType)file.getMediaType()), Response.class);
            }, ATTACHMENT_LIST);
        }
    }
}

