/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@LoginAs(user="admin")
public class TestGeneralConfiguration
extends BaseJiraFuncTest {
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreBlankInstance();
    }

    @After
    public void tearDown() {
        this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
    }

    @Test
    public void testAjaxIssuePicker() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.assertions.getTableAssertions().assertTableCellHasText(this.tester.getDialog().getWebTableBySummaryOrId("options_table"), 12, 1, "ON");
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("ajaxIssuePicker", "false");
        this.tester.submit("Update");
        this.assertions.getTableAssertions().assertTableCellHasText(this.tester.getDialog().getWebTableBySummaryOrId("options_table"), 12, 1, "OFF");
    }

    @Test
    public void testBaseUrlValidation() {
        String[] invalidURLs = new String[]{"", "http", "http://", "http://*&^%$#@", "http://example url.com:8090", "ldap://example.url.com:8090", "http://example.url.com:not_a_port", "http://example.url.com:8090/invalid path"};
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        for (String URL2 : invalidURLs) {
            this.tester.setFormElement("baseURL", URL2);
            this.tester.submit("Update");
            this.tester.assertTextPresent("You must set a valid base URL.");
        }
    }

    @Test
    public void testMimeSnifferOptions() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.assertTextPresent("Work around Internet Explorer security hole");
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("ieMimeSniffer", "secure");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Secure: forced download of attachments for all browsers");
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("ieMimeSniffer", "insecure");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Insecure: inline display of attachments");
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("ieMimeSniffer", "workaround");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Work around Internet Explorer security hole");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/jira/EditApplicationProperties.jspa?title=jWebTest+JIRA+installation&mode=public&captcha=false&baseURL=http%3A%2F%2Flocalhost%3A8080%2Fjira&emailFromHeaderFormat=%24%7Bfullname%7D+%28JIRA%29&introduction=&encoding=UTF-8&language=english&defaultLocale=-1&voting=true&watching=true&allowUnassigned=false&externalUM=false&logoutConfirm=never&useGzip=false&allowRpc=false&emailVisibility=show&groupVisibility=true&excludePrecedenceHeader=false&ajaxIssuePicker=true&ajaxUserPicker=true&Update=Update"));
        this.tester.assertTextPresent("The MIME sniffing policy option is required.");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/jira/EditApplicationProperties.jspa?title=jWebTest+JIRA+installation&mode=public&captcha=false&baseURL=http%3A%2F%2Flocalhost%3A8080%2Fjira&emailFromHeaderFormat=%24%7Bfullname%7D+%28JIRA%29&introduction=&encoding=UTF-8&language=english&defaultLocale=-1&voting=true&watching=true&allowUnassigned=false&externalUM=false&logoutConfirm=never&useGzip=false&allowRpc=false&emailVisibility=show&groupVisibility=true&excludePrecedenceHeader=false&ajaxIssuePicker=true&ajaxUserPicker=true&ieMimeSniffer=_WRONGARSE%26copy;&Update=Update"));
        this.tester.assertTextPresent("The given value for MIME sniffing policy is invalid: _WRONGARSE&amp;copy;");
    }

    @Test
    public void testLocalisesLanguageListItems() {
        String[] expectedOptions;
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.tester.gotoPage("secure/admin/jira/EditApplicationProperties!default.jspa");
        this.tester.setWorkingForm("jiraform");
        String[] languageOptions = this.tester.getDialog().getOptionsFor("defaultLocale");
        for (String expectedOption : expectedOptions = new String[]{"English (Australia)", "Deutsch (Deutschland)", "\u65e5\u672c\u8a9e (\u65e5\u672c)"}) {
            boolean found = false;
            for (String languageOption : languageOptions) {
                if (languageOption.indexOf(expectedOption) != 0) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assert.fail();
        }
    }

    @Test
    public void testMaxAuthattempts() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.textAssertions.assertTextSequence(this.locator.xpath("//table//tr[@id='maximumAuthenticationAttemptsAllowed']"), "Maximum Authentication Attempts Allowed", "3");
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("maximumAuthenticationAttemptsAllowed", "xzl");
        this.tester.submit("Update");
        this.textAssertions.assertTextPresent(this.locator.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "You must specify a number or leave it blank");
        this.tester.setFormElement("maximumAuthenticationAttemptsAllowed", "0");
        this.tester.submit("Update");
        this.textAssertions.assertTextPresent(this.locator.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "You cannot set the maximum authentication attempts to zero or less");
        this.tester.setFormElement("maximumAuthenticationAttemptsAllowed", "-1");
        this.tester.submit("Update");
        this.textAssertions.assertTextPresent(this.locator.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "You cannot set the maximum authentication attempts to zero or less");
        this.tester.setFormElement("maximumAuthenticationAttemptsAllowed", "10");
        this.tester.submit("Update");
        this.textAssertions.assertTextSequence(this.locator.xpath("//table//tr[@id='maximumAuthenticationAttemptsAllowed']"), "Maximum Authentication Attempts Allowed", "10");
    }

    @Test
    public void testMaxProjectNameLength() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.textAssertions.assertTextSequence(this.locator.xpath("//table//tr[@id='maximumLengthProjectNames']"), "Maximum project name size", "80");
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("maximumLengthProjectNames", "xzl");
        this.tester.submit("Update");
        this.textAssertions.assertTextPresent(this.locator.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "You must specify a number or leave it blank");
        this.tester.setFormElement("maximumLengthProjectNames", "0");
        this.tester.submit("Update");
        this.textAssertions.assertTextPresent(this.locator.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "The maximum project name length must be greater than 1.");
        this.tester.setFormElement("maximumLengthProjectKeys", "-1");
        this.tester.submit("Update");
        this.textAssertions.assertTextPresent(this.locator.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "The maximum project name length must be greater than 1.");
    }

    @Test
    public void testMaxProjectKeyLength() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.textAssertions.assertTextSequence(this.locator.xpath("//table//tr[@id='maximumLengthProjectKeys']"), "Maximum project key size", "10");
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("maximumLengthProjectKeys", "xzl");
        this.tester.submit("Update");
        this.textAssertions.assertTextPresent(this.locator.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "You must specify a number or leave it blank");
        this.tester.setFormElement("maximumLengthProjectKeys", "0");
        this.tester.submit("Update");
        this.textAssertions.assertTextPresent(this.locator.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "The maximum project key length must be greater than 1.");
        this.tester.setFormElement("maximumLengthProjectKeys", "-1");
        this.tester.submit("Update");
        this.textAssertions.assertTextPresent(this.locator.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "The maximum project key length must be greater than 1.");
    }

    @Test
    public void testXsrfDialogDisplayUrlParameters() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.textAssertions.assertTextSequence(this.locator.css("#options_table tbody tr[data-test-id=\"xsrf-dialog-params-display\"]"), "Display URL parameters in security dialogs", "OFF");
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("xsrfDialogDisplayParamsEnabled", "true");
        this.tester.submit("Update");
        this.textAssertions.assertTextSequence(this.locator.css("#options_table tbody tr[data-test-id=\"xsrf-dialog-params-display\"]"), "Display URL parameters in security dialogs", "ON");
    }

    @Test
    public void testIssueViewCommentReactions() {
        try {
            this.backdoor.restoreBlankDataCenterInstance();
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.COMMENT_REACTIONS);
            this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
            this.textAssertions.assertTextSequence(this.locator.css("#options_table tbody tr[data-test-id=\"issue-view-comment-reactions\"]"), "Enable emoji reactions", "ON");
            this.tester.clickLink("edit-app-properties");
            this.tester.setFormElement("issueCommentReactionsEnabled", "false");
            this.tester.submit("Update");
            this.textAssertions.assertTextSequence(this.locator.css("#options_table tbody tr[data-test-id=\"issue-view-comment-reactions\"]"), "Enable emoji reactions", "OFF");
        }
        finally {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.COMMENT_REACTIONS);
        }
    }

    @Test
    public void testLocaleWhitelistValidation() {
        String[] invalidLocales = new String[]{"zt_ZT", "AF_ZA", "<script>alert()</script>"};
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        for (String locale : invalidLocales) {
            FormParameterUtil formHelper = new FormParameterUtil(this.tester, "jiraform", "Update");
            formHelper.setFormElement("defaultLocale", locale);
            Node document = formHelper.submitForm();
            XPathLocator locator = new XPathLocator(document, "//*[@class='errMsg']");
            Assert.assertTrue((boolean)locator.getText().contains(String.format("Locale '%s' is not a valid locale.", locale)));
            this.tester.reset();
        }
    }
}

