/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.IMPORT_EXPORT})
@LoginAs(user="admin")
public class TestImportExport
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testXmlImportFromNonImportDirectory() throws Exception {
        File data = new File(this.getEnvironmentData().getXMLDataLocation(), "EmptyJira.xml");
        File newData = File.createTempFile("testXmlImportFromNonImportDirectory", ".xml");
        try {
            FileUtils.copyFile((File)data, (File)newData);
            this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
            this.tester.setWorkingForm("restore-xml-data-backup");
            this.tester.setFormElement("filename", newData.getAbsolutePath());
            this.tester.submit();
            this.tester.assertTextPresent("Could not find file at this location");
        }
        finally {
            newData.delete();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testXmlImportWithInvalidAttachmentsDirectory() throws Exception {
        File attachmentPath = File.createTempFile("testXmlImportWithInvalidAttachmentsDirectory", null);
        attachmentPath.createNewFile();
        attachmentPath.deleteOnExit();
        String absolutePath = attachmentPath.getAbsolutePath();
        this.importExpectingFailure("TestSetupInvalidAttachmentPath.xml", (Map<String, String>)ImmutableMap.of((Object)"@@ATTACHMENT_PATH@@", (Object)absolutePath));
        this.tester.assertTextPresent("Cannot write to attachment directory. Check that the application server and Jira have permissions to write to: " + absolutePath);
    }

    private void importExpectingFailure(String xmlFileName, Map<String, String> replacements) throws IOException {
        try {
            this.administration.restoreDataWithReplacedTokens(xmlFileName, replacements);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testXmlImportFromFuture_Fail() {
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/TestXmlImportFromFuture_Fail.xml");
        this.copyToJiraImportDirectory(file);
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("restore-xml-data-backup");
        this.tester.setFormElement("filename", file.getName());
        this.tester.setFormElement("license", LicenseKeys.COMMERCIAL_DC.getLicenseString());
        this.tester.submit();
        this.administration.waitForRestore();
        this.tester.assertTextNotPresent("Your import has been successful");
        this.tester.assertTextPresent("The file you are trying to import is from Jira 999.9.9, which is newer than your current version of Jira and will not work. The import file claims it can be successfully imported into Jira 99.8.7 or later.");
        this.tester.assertTextPresent("If Jira 99.8.7 is not yet available for download, please contact support.");
    }

    @Test
    public void testXmlImportFromFuture_DowngradeNoOp() {
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/TestXmlImportFromFuture.xml");
        this.copyToJiraImportDirectory(file);
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("restore-xml-data-backup");
        this.tester.setFormElement("filename", file.getName());
        this.tester.setFormElement("license", LicenseKeys.COMMERCIAL_DC.getLicenseString());
        this.tester.submit();
        this.administration.waitForRestore();
        this.tester.assertTextPresent("You are attempting to import data from Jira 999.9.9 which is a more recent version than this version.");
        this.tester.assertTextPresent("Some features that you may have used before will not be available in this version of Jira.");
        this.tester.assertTextPresent("acknowledge this error and proceed anyway.");
    }

    private void copyToJiraImportDirectory(File file) {
        File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
        try {
            FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
        }
    }
}

