/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.HasItemsInOrderMatcher;
import com.atlassian.jira.matchers.HasSubsequenceMatcher;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestIssueFeaturesAdminItemsLayout
extends BaseJiraFuncTest {
    @Inject
    LocatorFactory locatorFactory;

    @Test
    public void shouldAddIssueFeaturesToIssuesPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        List<String> headersTexts = this.getAdminMenuHeadings();
        List<String> allMenuItemsTexts = this.getAllAdminMenuItems();
        Assert.assertThat(headersTexts, (Matcher)HasItemsInOrderMatcher.hasItemsInOrder((Object[])new String[]{"Fields", "Issue Features"}));
        Assert.assertThat(allMenuItemsTexts, (Matcher)HasSubsequenceMatcher.hasSubsequenceOf((Object[])new String[]{"Issue Features", "Time tracking", "Issue linking"}));
    }

    private List<String> getAdminMenuHeadings() {
        Node[] headers = this.locatorFactory.css(".admin-menu-links .aui-nav-heading").getNodes();
        return TestIssueFeaturesAdminItemsLayout.extractNodeValues(headers);
    }

    private List<String> getAllAdminMenuItems() {
        Node[] allMenuLabels = this.locatorFactory.css(".admin-menu-links :matchesOwn([A-Za-z])").getNodes();
        return TestIssueFeaturesAdminItemsLayout.extractNodeValues(allMenuLabels);
    }

    private static List<String> extractNodeValues(Node[] nodes) {
        Function<Node, String> trimNodeValue = ((Function<Node, String>)Node::getNodeValue).andThen(String::trim);
        return (List)Stream.of(nodes).map(trimNodeValue).collect(CollectorsUtil.toImmutableListWithCapacity((int)nodes.length));
    }
}

