/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
public class TestLookAndFeel
extends BaseJiraFuncTest {
    private static final String LOGO_PREVIEW_IMAGE_CSS_SELECTOR = "img.application-logo.logo-preview";
    private static final String FAVICON_PREVIEW_IMAGE_CSS_SELECTOR = "img.application-logo.favicon-preview";
    private static final String IMAGE_EXTENSION = ".png";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.LOOKANDFEEL);
    }

    @Test
    public void itShowsCurrentlyUsedLogoAndFavicon() {
        String logoUrlAsDisplayedInThePreview = this.locator.css(LOGO_PREVIEW_IMAGE_CSS_SELECTOR).getNode().getAttributes().getNamedItem("src").getTextContent();
        MatcherAssert.assertThat((Object)logoUrlAsDisplayedInThePreview, (Matcher)CoreMatchers.endsWith((String)IMAGE_EXTENSION));
        String favIconUrlAsDisplayedInThePreview = this.locator.css(FAVICON_PREVIEW_IMAGE_CSS_SELECTOR).getNode().getAttributes().getNamedItem("src").getTextContent();
        MatcherAssert.assertThat((Object)favIconUrlAsDisplayedInThePreview, (Matcher)CoreMatchers.endsWith((String)IMAGE_EXTENSION));
    }
}

