/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.PermissionSchemesMatcher;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.PERMISSIONS, Category.SCHEMES})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestPermissionSchemesBackdoorImpl
extends BaseJiraFuncTest {
    private static final String NEW_SCHEME_NAME = "TestPermissionSchemesBackdoorImplScheme";
    private Long createdSchemeId = -1L;
    @Inject
    private Administration administration;

    @Before
    public void createScheme() {
        this.createdSchemeId = this.backdoor.permissionSchemes().createScheme(NEW_SCHEME_NAME, "");
    }

    @After
    public void destroyScheme() {
        this.backdoor.permissionSchemes().deleteScheme(this.createdSchemeId.longValue());
    }

    @Test
    public void testAddPermissionToDefaultScheme() {
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.CREATE_ISSUES, "jira-users");
        PermissionSchemeBean permissionSchemesBean = this.backdoor.permissionSchemes().getAssignedPermissions(0L);
        Assert.assertTrue((String)"Should have assigned the anyone permission to creating issues", (boolean)PermissionSchemesMatcher.hasPermission(ProjectPermissions.CREATE_ISSUES.permissionKey(), JiraPermissionHolderType.GROUP.getKey(), "jira-users").matches((Object)permissionSchemesBean));
    }

    @Test
    public void testAddingAnyoneGroupPermission() {
        this.administration.permissionSchemes().scheme(NEW_SCHEME_NAME).grantPermissionToGroup(ProjectPermissions.CREATE_ISSUES, "");
        PermissionSchemeBean permissionSchemesBean = this.backdoor.permissionSchemes().getAssignedPermissions(this.createdSchemeId.longValue());
        Assert.assertTrue((String)"Should have assigned the anyone permission to creating issues", (boolean)PermissionSchemesMatcher.hasPermission(ProjectPermissions.CREATE_ISSUES.permissionKey(), JiraPermissionHolderType.GROUP.getKey(), null).matches((Object)permissionSchemesBean));
    }

    @Test
    public void testAddingAnyLoggedInUserApplicationRolePermission() {
        this.administration.permissionSchemes().scheme(NEW_SCHEME_NAME).grantPermissionToApplicationRole(ProjectPermissions.CREATE_ISSUES, "");
        PermissionSchemeBean permissionSchemesBean = this.backdoor.permissionSchemes().getAssignedPermissions(this.createdSchemeId.longValue());
        Assert.assertTrue((String)"Should have assigned the any logged in permission to creating issues", (boolean)PermissionSchemesMatcher.hasPermission(ProjectPermissions.CREATE_ISSUES.permissionKey(), JiraPermissionHolderType.APPLICATION_ROLE.getKey(), null).matches((Object)permissionSchemesBean));
    }
}

