/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
public class TestResolutions
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    public void testSameName() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.RESOLUTIONS);
        this.addResolution("Fixed");
        this.assertDuplicateResolutionError();
        this.addResolution("fixED");
        this.assertDuplicateResolutionError();
        this.tester.gotoPage("secure/admin/EditResolution!default.jspa?id=2");
        this.tester.setFormElement("name", "Fixed");
        this.tester.submit();
        this.assertDuplicateResolutionError();
        this.tester.setFormElement("name", "FIXED");
        this.tester.submit();
        this.assertDuplicateResolutionError();
    }

    private void assertDuplicateResolutionError() {
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("This name is already taken.");
    }

    private void addResolution(String name) {
        this.tester.setFormElement("name", name);
        this.tester.submit();
    }

    @Test
    public void testNoDefaultResolutionsOnNewInstance() {
        this.administration.restoreData("TestDefaultResolutions.xml");
        List resolutions = this.backdoor.getTestkit().resolutions().getResolutions();
        Assert.assertThat((Object)resolutions, (Matcher)Matchers.empty());
    }
}

