/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.MailServerAdministration;
import com.atlassian.jira.functest.framework.admin.ViewServices;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.PERMISSIONS})
@LoginAs(user="admin")
public class TestSystemAdminAndAdminPermissions
extends BaseJiraFuncTest {
    private static final String MAIL_SERVER_ADMINISTRATION_URL = "/secure/admin/OutgoingMailServers.jspa";
    private static final String SETUP_MAIL_SERVER_WARNING_LINK_TEXT = "mail server";
    private static final String NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR = "//*[@id='no-mail-server-setup-warning']";
    private static final String SETUP_MAIL_SERVER_WARNING_LINK_LOCATOR = "//*[@id='no-mail-server-setup-warning']/a";
    private static final String CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR = "//*[@id='configure_mail_server']/../..[@class='desc-wrap']";
    private static final String CONFIGURE_MAIL_SERVER_LINK_TEXT = "configure";
    private static final String VIEW_SERVICES_PAGE_FORM_TITLES_LOCATOR = ".formtitle";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testRemoveAdminFromJiraUsers() {
        this.restoreTestSystemAdminAndAdminPermissions();
        this.administration.usersAndGroups().removeUserFromGroup("nonsystemadmin", "jira-users");
        this.navigation.login("nonsystemadmin", "nonsystemadmin");
        this.tester.assertLinkPresent("log_out");
    }

    private void restoreTestSystemAdminAndAdminPermissions() {
        this.administration.restoreData("TestSystemAdminAndAdminPermissions.xml");
    }

    @Test
    public void testRemoveSysAdminFromJiraUsers() {
        this.restoreTestSystemAdminAndAdminPermissions();
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-users");
        this.navigation.logout();
        this.navigation.login("admin");
        this.tester.assertLinkPresent("log_out");
    }

    @Test
    public void testRemoveSysAdminFromAdminsAndJiraUsers() {
        this.restoreTestSystemAdminAndAdminPermissions();
        this.administration.usersAndGroups().addGroup("systemadmins");
        this.administration.addGlobalPermission(44, "systemadmins");
        this.administration.usersAndGroups().addUserToGroup("admin", "systemadmins");
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-users");
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-administrators");
        this.navigation.logout();
        this.navigation.login("admin");
        this.tester.assertLinkPresent("log_out");
    }

    private void restoreAdminPermission() {
        this.navigation.logout();
        this.navigation.login("root", "root");
        this.administration.addGlobalPermission(GlobalPermissionKey.SYSTEM_ADMIN, "jira-administrators");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testNotificationSchemeMailServerWarningAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    private void restoreTestWithSystemAdmin() {
        this.administration.restoreData("TestWithSystemAdmin.xml");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testNotificationSchemeMailServerWarningAsSysAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
            this.assertions.getLinkAssertions().assertLinkAtNodeContains(SETUP_MAIL_SERVER_WARNING_LINK_LOCATOR, MAIL_SERVER_ADMINISTRATION_URL);
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testEditNotificationSchemeMailServerWarningAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
            this.tester.clickLinkWithText("Default Notification Scheme");
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testEditNotificationSchemeMailServerWarningAsSysAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
            this.tester.clickLinkWithText("Default Notification Scheme");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
            this.assertions.getLinkAssertions().assertLinkAtNodeContains(SETUP_MAIL_SERVER_WARNING_LINK_LOCATOR, MAIL_SERVER_ADMINISTRATION_URL);
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testSendBulkMailMailServerWarningAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.gotoAdminSection(Navigation.AdminSection.SEND_EMAIL);
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR, CONFIGURE_MAIL_SERVER_LINK_TEXT);
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testSendBulkMailMailServerWarningAsSysAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.SEND_EMAIL);
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText(CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR, CONFIGURE_MAIL_SERVER_LINK_TEXT);
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testMailQueueMailServerWarningAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.gotoAdminSection(Navigation.AdminSection.MAIL_QUEUE);
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//*[@class='jiraformheader']//*[@class='warning']/../..", SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testMailQueueMailServerWarningAsSysAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.MAIL_QUEUE);
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//*[@class='jiraformheader']//*[@class='warning']/../..", SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testDeleteProjectBackupWarningAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
            this.tester.clickLinkWithText("Delete");
            this.tester.assertLinkNotPresentWithText("back it up first");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testDeleteProjectBackupWarningAsSysAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
            this.tester.clickLinkWithText("Delete");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("create a back up");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testActivateWorkflowBackupWarningAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.createNewWorkflowSchemeAndGotoAssociateProject();
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("", "backup");
            this.tester.selectOption("schemeId", "Test");
            this.tester.submit("Associate");
            this.tester.assertTextPresent("2 of 3");
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("", "backup");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testActivateWorkflowBackupWarningAsSysAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.createNewWorkflowSchemeAndGotoAssociateProject();
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("backup");
            this.tester.selectOption("schemeId", "Test");
            this.tester.submit("Associate");
            this.tester.assertTextPresent("2 of 3");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testDeleteWorkflowBackupWarningAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira");
            this.administration.workflows().goTo();
            this.tester.clickLink("del_Copy of jira");
            this.tester.assertLinkNotPresentWithText("do a full backup");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testDeleteWorkflowBackupWarningAsSysAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira");
            this.administration.workflows().goTo();
            this.tester.clickLink("del_Copy of jira");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("do a full backup");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    public void testViewGroupEditLinkNotPresentAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            this.tester.clickLinkWithText("jira-sys-admins");
            this.tester.assertLinkNotPresent("edit_members_of_jira-sys-admins");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testViewGroupEditLinkPresentAsSysAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            this.tester.clickLinkWithText("jira-sys-admins");
            this.tester.assertLinkPresent("edit_members_of_jira-sys-admins");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testUserBrowserEditAndDeleteLinkNotPresentAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.assertLinkNotPresent("edituser_link_root");
            this.tester.assertLinkNotPresent("deleteuser_link_root");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testUserBrowserEditAndDeleteLinkPresentAsSysAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.assertLinkPresent("edituser_link_root");
            this.tester.assertLinkPresent("deleteuser_link_root");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAttachmentEditLinkNotPresentAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
            this.tester.assertLinkNotPresentWithText("Edit Settings");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAttachmentEditAsAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/jira/EditAttachmentSettings.jspa?thumbnailsEnabled=true"));
            this.tester.assertTextPresent("Attachments must be enabled to enable thumbnails.");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAttachmentEditLinkPresentAsSysAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
            this.tester.assertLinkPresentWithText("Edit Settings");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdvancedSettingsWorksForSysAdminWhoIsAlsoAdmin() {
        this.areAdvancedSettingsWorkingForUser("root", "root");
    }

    private void areAdvancedSettingsWorkingForUser(String userName, String userPassword) {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login(userName, userPassword);
            this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
            this.tester.assertLinkPresentWithText("Advanced Settings");
            this.navigation.gotoAdminSection(Navigation.AdminSection.ADVANCED_SETTINGS);
            this.tester.assertTextPresent("Advanced Settings");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdvancedSettingsWorksForSysAdminWhoIsNotAdmin() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.usersAndGroups().removeUserFromGroup("root", "jira-administrators");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
            this.tester.assertLinkPresentWithText("Advanced Settings");
            this.navigation.gotoAdminSection(Navigation.AdminSection.ADVANCED_SETTINGS);
            this.tester.assertTextPresent("Advanced Settings");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdvancedSettingsWorksForAdmin() {
        this.areAdvancedSettingsWorkingForUser("admin", "admin");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdvancedSettingsDoesNotWorkForNormalUser() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("fred", "fred");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
            this.tester.assertTextPresent("does not have permission to access this page");
            this.navigation.gotoAdminSection(Navigation.AdminSection.ADVANCED_SETTINGS);
            this.tester.assertTextPresent("does not have permission to access this page");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminCanNotElevateHisPrivilegesBySettingSysAdminPassword() {
        try {
            this.restoreTestWithSystemAdmin();
            this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=root");
            this.textAssertions.assertTextNotPresent(this.locator.page(), "Set Password");
            this.textAssertions.assertTextPresent(this.locator.page(), "This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.tester.gotoPage("/secure/admin/user/SetPassword!default.jspa?name=root");
            this.tester.setFormElement("password", "newpassword");
            this.tester.setFormElement("confirm", "newpassword");
            this.tester.clickButton("user-edit-password-submit");
            this.textAssertions.assertTextNotPresent(this.locator.page(), "has successfully been set ");
            this.assertions.getJiraFormAssertions().assertFormErrMsg("Must be a System Administrator to reset a System Administrator's password");
            this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=admin");
            this.textAssertions.assertTextPresent(this.locator.page(), "Set Password");
            this.tester.gotoPage("secure/admin/user/SetPassword!default.jspa?name=admin");
            this.tester.setFormElement("password", "newpassword");
            this.tester.setFormElement("confirm", "newpassword");
            this.tester.clickButton("user-edit-password-submit");
            this.assertions.getJiraFormAssertions().assertFormSuccessMsg("has successfully been set");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminUsersCanAccessTheServicesAdministrationPage() {
        try {
            this.restoreTestWithSystemAdmin();
            this.administration.services().goTo();
            this.assertThatTheCurrentPageIsViewServices();
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testSysAdminUsersCanAccessTheServicesAdministrationPage() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.services().goTo();
            this.assertThatTheCurrentPageIsViewServices();
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testSysAdminUsersCanViewAllServices() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            ImmutableSet expectedListOfServices = ImmutableSet.of((Object)new ViewServices.Service("An IMAP Service", "com.atlassian.jira.service.services.mail.MailFetcherService"), (Object)new ViewServices.Service("A Debugging Service", "com.atlassian.jira.service.services.DebugService"), (Object)new ViewServices.Service("Backup JIRA", "com.atlassian.jira.service.services.export.ExportService"), (Object)new ViewServices.Service("A Pop Service", "com.atlassian.jira.service.services.mail.MailFetcherService"), (Object)new ViewServices.Service("Mail Queue Service", "com.atlassian.jira.service.services.mail.MailQueueService"));
            this.navigation.logout();
            this.navigation.login("root", "root");
            Set<ViewServices.Service> actualListOfServices = this.administration.services().goTo().list();
            Assert.assertTrue((boolean)actualListOfServices.containsAll((Collection<?>)expectedListOfServices));
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminUsersCanOnlySeePopAndImapServices() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            ImmutableSet expectedListOfServices = ImmutableSet.of((Object)new ViewServices.Service("An IMAP Service", "com.atlassian.jira.service.services.mail.MailFetcherService"), (Object)new ViewServices.Service("A Pop Service", "com.atlassian.jira.service.services.mail.MailFetcherService"));
            Set<ViewServices.Service> actualListOfServices = this.administration.services().goTo().list();
            Assert.assertTrue((boolean)expectedListOfServices.equals(actualListOfServices));
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testSysAdminUsersCanAddABuiltInServiceThatIsNeitherAnImapNorPop() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            ViewServices.Service serviceToAdd = new ViewServices.Service("Another Backup JIRA", "com.atlassian.jira.service.services.export.ExportService");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.services().goTo().add(serviceToAdd, "10");
            Set<ViewServices.Service> existingServices = this.administration.services().goTo().list();
            Assert.assertTrue((boolean)existingServices.contains(serviceToAdd));
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminUsersCanOnlyAddPopAndImapServices() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            this.administration.services().goTo();
            this.tester.assertFormNotPresent("jiraform");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminUsersCanOnlySeePopServers() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            MailServerAdministration.MailServerConfiguration expectedPopConfiguration = new MailServerAdministration.MailServerConfiguration("Dummy POP Server", "dummy", "dummy");
            this.navigation.gotoAdmin();
            Assert.assertFalse((String)"Admin should not be able to see list of smtp servers", (boolean)this.administration.mailServers().Smtp().goTo().isPresent());
            Assert.assertTrue((boolean)this.administration.mailServers().Pop().goTo().isPresent());
            List<MailServerAdministration.MailServerConfiguration> actualListOfConfiguredPopServers = this.administration.mailServers().Pop().goTo().list();
            Assert.assertEquals(actualListOfConfiguredPopServers, (Object)ImmutableList.of((Object)expectedPopConfiguration));
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testSysAdminUsersCanSeeSmtpAndPopServers() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            MailServerAdministration.MailServerConfiguration expectedPopConfiguration = new MailServerAdministration.MailServerConfiguration("Dummy POP Server", "dummy", "dummy");
            this.navigation.logout();
            this.navigation.login("root", "root");
            Assert.assertTrue((boolean)this.administration.mailServers().Smtp().goTo().isPresent());
            Assert.assertFalse((boolean)this.administration.mailServers().Smtp().goTo().isConfigured());
            Assert.assertTrue((boolean)this.administration.mailServers().Pop().goTo().isPresent());
            List<MailServerAdministration.MailServerConfiguration> actualListOfConfiguredPopServers = this.administration.mailServers().Pop().goTo().list();
            Assert.assertEquals(actualListOfConfiguredPopServers, (Object)ImmutableList.of((Object)expectedPopConfiguration));
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminUsersCanAddAPopServer() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            MailServerAdministration.MailServerConfiguration mailServerConfigurationToBeAdded = new MailServerAdministration.MailServerConfiguration("New Pop Server", "dummy", "dummy");
            this.administration.mailServers().Pop().goTo().add(mailServerConfigurationToBeAdded.getName(), mailServerConfigurationToBeAdded.getHostName(), mailServerConfigurationToBeAdded.getUserName(), "dummy");
            List<MailServerAdministration.MailServerConfiguration> actualListOfConfiguredPopServers = this.administration.mailServers().Pop().goTo().list();
            Assert.assertTrue((boolean)actualListOfConfiguredPopServers.contains(mailServerConfigurationToBeAdded));
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminUsersCanEditAPopServer() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            MailServerAdministration.MailServerConfiguration expectedUpdatedMailServerConfiguration = new MailServerAdministration.MailServerConfiguration("Dummy POP Server", "PIRATES.AYE.AYE.COM", "Barbarossa");
            this.administration.mailServers().Pop().goTo().edit("Dummy POP Server").setHostName("PIRATES.AYE.AYE.COM").setUserName("Barbarossa").setPassword("secure-password").update();
            List<MailServerAdministration.MailServerConfiguration> actualListOfConfiguredPopServers = this.administration.mailServers().Pop().goTo().list();
            Assert.assertTrue((boolean)Iterables.contains(actualListOfConfiguredPopServers, (Object)expectedUpdatedMailServerConfiguration));
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminUsersCanDeleteAPopServer() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            this.administration.mailServers().Pop().goTo().delete("Dummy POP Server");
            List<MailServerAdministration.MailServerConfiguration> actualListOfConfiguredPopServers = this.administration.mailServers().Pop().goTo().list();
            Assert.assertTrue((boolean)Iterables.isEmpty(actualListOfConfiguredPopServers));
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminCanNotAccessSendTestMailByUrlHacking() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            this.tester.gotoPage("secure/admin/SendTestMail!default.jspa");
            this.textAssertions.assertTextPresent(this.locator.css(".aui-message.aui-message-warning"), "'Administrator' does not have permission to access this page");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testImportWorkflowFromXmlButtonShouldNotBeDisplayedForAdministrators() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            Assert.assertFalse((boolean)this.administration.workflows().goTo().isImportWorkflowFromXmlButtonPresent());
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testImportWorkflowFromXmlButtonShouldBeDisplayedForSystemAdministrators() throws Exception {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            Assert.assertTrue((boolean)this.administration.workflows().goTo().isImportWorkflowFromXmlButtonPresent());
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testThatAdminCanNotLoginWithoutAppRole() {
        try {
            this.restoreTestWithSystemAdmin();
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.assertLinkPresent("edituser_link_root");
            this.tester.assertLinkPresent("deleteuser_link_root");
            this.backdoor.usersAndGroups().addGroup("no-users");
            this.backdoor.usersAndGroups().addGroup("single-admin");
            this.backdoor.usersAndGroups().addUser("newadmin");
            this.backdoor.usersAndGroups().addUserToGroup("newadmin", "single-admin");
            this.backdoor.usersAndGroups().addUserToGroup("newadmin", "jira-sys-admins");
            this.backdoor.applicationRoles().putRoleWithDefaults("jira-software", Sets.newHashSet((Object[])new String[]{"no-users", "single-admin"}), Sets.newHashSet());
            this.navigation.logout();
            this.navigation.loginAttempt("root", "root");
            this.tester.assertTextNotPresent("Sorry, your username and password are incorrect - please try again.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("newadmin", "newadmin");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    public void testAdminCanLoginWhenMovedToAnotherRole() {
        this.backdoor.restoreBlankInstance(LicenseKeys.MULTI_ROLE_DC);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        String noUsers = "no-users";
        this.backdoor.usersAndGroups().addGroup("no-users");
        Assert.assertTrue((boolean)this.backdoor.applicationRoles().getRole("jira-core").getGroups().contains("jira-administrators"));
        Assert.assertTrue((boolean)this.backdoor.applicationRoles().getRole("jira-software").getGroups().contains("jira-administrators"));
        Assert.assertFalse((boolean)this.backdoor.applicationRoles().getRole("jira-servicedesk").getGroups().contains("jira-administrators"));
        this.backdoor.applicationRoles().putRole("jira-servicedesk", "jira-administrators");
        this.backdoor.applicationRoles().putRole("jira-core", "no-users");
        this.backdoor.applicationRoles().putRole("jira-software", "no-users");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
    }

    private void assertThatTheCurrentPageIsViewServices() {
        this.textAssertions.assertTextSequence(this.locator.css(VIEW_SERVICES_PAGE_FORM_TITLES_LOCATOR), "Services", "Add Service");
    }

    private void createNewWorkflowSchemeAndGotoAssociateProject() {
        this.navigation.gotoAdmin();
        this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira");
        this.backdoor.workflowSchemes().createScheme(new WorkflowSchemeData().setName("Test").setDefaultWorkflow("Copy of jira"));
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowScheme!default.jspa?projectId=10000");
    }
}

