/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.HasItemsInOrderMatcher;
import com.atlassian.jira.matchers.HasSubsequenceMatcher;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestSystemAdminItemsLayout
extends BaseJiraFuncTest {
    @Inject
    private LocatorFactory locatorFactory;
    private List<String> headersTexts;
    private List<String> allMenuItemsTexts;

    @Before
    public void setUp() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.headersTexts = this.getAdminMenuHeadings();
        this.allMenuItemsTexts = this.getAllAdminMenuItems();
    }

    @Test
    public void shouldAddTopAdministrationTabsInCorrectOrder() {
        Assert.assertThat(this.getTopAdministrationTabs(), (Matcher)Matchers.contains((Object[])new String[]{"Applications", "Projects", "Issues", "Manage apps", "User management", "Latest upgrade report", "System"}));
    }

    @Test
    public void shouldAddIssueCollectorsToSystemPage() {
        Assert.assertThat(this.headersTexts, (Matcher)HasItemsInOrderMatcher.hasItemsInOrder((Object[])new String[]{"Security", "User Interface"}));
        Assert.assertThat(this.allMenuItemsTexts, (Matcher)HasItemsInOrderMatcher.hasItemsInOrder((Object[])new String[]{"Security", "Issue collectors"}));
    }

    @Test
    public void shouldAddProjectRolesToSecuritySection() {
        Assert.assertThat(this.allMenuItemsTexts, (Matcher)HasSubsequenceMatcher.hasSubsequenceOf((Object[])new String[]{"Security", "Project roles"}));
    }

    @Test
    public void shouldAddAtlassianSupportToolsToTroubleshootinAdnSupportSection() {
        Assert.assertThat(this.headersTexts, (Matcher)HasSubsequenceMatcher.hasSubsequenceOf((Object[])new String[]{"System Support", "Security"}));
        Assert.assertThat(this.allMenuItemsTexts, (Matcher)HasItemsInOrderMatcher.hasItemsInOrder((Object[])new String[]{"System Support", "Troubleshooting and support tools"}));
    }

    @Test
    public void shouldAddDatabaseMonitoringToTroubleshootinAdnSupportSection() {
        Assert.assertThat(this.allMenuItemsTexts, (Matcher)HasItemsInOrderMatcher.hasItemsInOrder((Object[])new String[]{"System Support", "Database monitoring"}));
        Assert.assertThat(this.allMenuItemsTexts, (Matcher)HasSubsequenceMatcher.hasSubsequenceOf((Object[])new String[]{"Instrumentation", "Monitoring", "Database monitoring", "Integrity checker"}));
    }

    @Test
    public void orderOfItemsInTroubleshootingAndSupportSectionShouldBeFixed() {
        Assert.assertThat(this.headersTexts, (Matcher)HasSubsequenceMatcher.hasSubsequenceOf((Object[])new String[]{"System Support", "Security"}));
        Assert.assertThat(this.allMenuItemsTexts, (Matcher)HasItemsInOrderMatcher.hasItemsInOrder((Object[])new String[]{"System Support", "System info", "Instrumentation", "Integrity checker", "Logging and profiling", "Scheduler details", "Security"}));
    }

    @Test
    public void shouldAddAdminHelperItemsToSystemPage() {
        Assert.assertThat(this.headersTexts, (Matcher)HasItemsInOrderMatcher.hasItemsInOrder((Object[])new String[]{"Mail", "Admin helper", "Shared Items"}));
        Assert.assertThat(this.allMenuItemsTexts, (Matcher)HasSubsequenceMatcher.hasSubsequenceOf((Object[])new String[]{"Admin helper", "Permission helper", "Notification helper"}));
    }

    private List<String> getAdminMenuHeadings() {
        Node[] headers = this.locatorFactory.css(".admin-menu-links .aui-nav-heading").getNodes();
        return TestSystemAdminItemsLayout.extractNodeValues(headers);
    }

    private List<String> getAllAdminMenuItems() {
        Node[] allMenuLabels = this.locatorFactory.css(".admin-menu-links :matchesOwn([A-Za-z])").getNodes();
        return TestSystemAdminItemsLayout.extractNodeValues(allMenuLabels);
    }

    private List<String> getTopAdministrationTabs() {
        Node[] administrationTabs = this.locatorFactory.css("#admin-nav-heading .aui-nav li span").getNodes();
        return TestSystemAdminItemsLayout.extractNodeValues(administrationTabs);
    }

    private static List<String> extractNodeValues(Node[] nodes) {
        Function<Node, String> trimNodeValue = ((Function<Node, String>)Node::getNodeValue).andThen(String::trim);
        return (List)Stream.of(nodes).map(trimNodeValue).collect(CollectorsUtil.toImmutableListWithCapacity((int)nodes.length));
    }
}

