/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.apdex;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.AnalyticsEventsControl;
import com.atlassian.jira.functest.framework.backdoor.ApdexControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.google.common.collect.ImmutableMap;
import com.jayway.awaitility.Awaitility;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestApdexCategories
extends BaseJiraFuncTest {
    private static final FeatureFlag APDEX_STATS = FeatureFlag.featureFlag((String)"jira.apdex.stats");
    ApdexControl apdexControl;
    AnalyticsEventsControl analyticsControl;

    @Before
    public void setUp() throws Exception {
        this.apdexControl = this.backdoor.apdexControl();
        this.analyticsControl = this.backdoor.analyticsEventsControl();
        this.apdexControl.flush();
        this.analyticsControl.enable().clear();
    }

    @Test
    public void testApdexCategory() {
        this.publishApdex(1.0f, "jira.dashboard");
        this.publishApdex(0.5f, "jira.dashboard");
        Assert.assertEquals((long)75L, (long)this.apdexControl.getApdex("jira.dashboard"));
    }

    @Test
    public void testApdexDisabled() {
        this.backdoor.darkFeatures().disableForSite(APDEX_STATS);
        try {
            this.publishApdex(1.0f, "jira.dashboard");
            this.publishApdex(0.5f, "jira.dashboard");
            Assert.assertEquals((long)-1L, (long)this.apdexControl.getApdex("jira.dashboard"));
        }
        finally {
            this.backdoor.darkFeatures().enableForSite(APDEX_STATS);
        }
    }

    @Test
    public void testApdexAnalytics() {
        this.verifyEvent("jira.dashboard");
        this.verifyEvent("jira.issue.view");
    }

    private void verifyEvent(String key) {
        this.apdexControl.flush();
        this.analyticsControl.clear();
        this.publishApdex(1.0f, key);
        this.publishApdex(0.5f, key);
        this.apdexControl.sendAnalytics();
        this.assertEvent("jira.apdex.apdexentry", key);
    }

    private void assertEvent(String name, String key) {
        Map eventMap = (Map)((List)Awaitility.await().until(() -> this.backdoor.analyticsEventsControl().matchEvents(name), Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))))).get(1);
        Assert.assertEquals((Object)key, ((Map)eventMap.get("properties")).get("key"));
    }

    private AnalyticsEventsControl publishApdex(float apdex, String category) {
        return this.analyticsControl.publish(new AnalyticsEventsControl.BrowserEventBean("browser.metrics.navigation", (Map<String, Object>)ImmutableMap.of((Object)"apdex", (Object)Float.valueOf(apdex), (Object)"key", (Object)category), 0L));
    }
}

