/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES, Category.SCHEMES, Category.ISSUE_TYPES})
@Restore(value="TestIssueTypeSchemes.xml")
@LoginAs(user="admin")
public class TestIssueTypeSchemes
extends BaseJiraFuncTest {
    private static final String DEFAULT_ISSUE_TYPE_SCHEME_NAME = "Default Issue Type Scheme";
    private static final String DEFAULT_ISSUE_TYPE_SCHEME_DESC = "Default issue type scheme is the list of global issue types. All newly created issue types will automatically be added to this scheme.";
    @Inject
    private Form form;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testIssueTypeSchemesSelectOrder() throws SAXException {
        this.administration.restoreData("TestIssueTypeSchemes_Order.xml");
        this.navigation.gotoAdmin();
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        WebForm select = this.tester.getDialog().getResponse().getFormWithName("jiraform");
        String[] values = select.getOptionValues("schemeId");
        Assert.assertEquals((Object)"10000", (Object)values[0]);
        Assert.assertEquals((Object)"10010", (Object)values[1]);
        Assert.assertEquals((Object)"10013", (Object)values[2]);
        Assert.assertEquals((Object)"10012", (Object)values[3]);
        Assert.assertEquals((Object)"10011", (Object)values[4]);
    }

    @Test
    public void testIssueTypeSchemesView() {
        this.gotoIssueTypeSchemes();
        this.assertCommonIssueTypeSchemesTable();
    }

    @Test
    public void testIssueTypeSchemeEdit() {
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("edit_10000");
        this.tester.assertFormElementEquals("name", DEFAULT_ISSUE_TYPE_SCHEME_NAME);
        this.tester.assertFormElementEquals("description", DEFAULT_ISSUE_TYPE_SCHEME_DESC);
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("edit_10010");
        this.tester.assertFormElementEquals("name", "Test Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for test issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("edit_10011");
        this.tester.assertFormElementEquals("name", "Associated Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for associated issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
    }

    @Test
    public void testIssueTypeSchemeDelete() {
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("delete_10011");
        this.tester.assertTextPresent("Delete Issue Type Scheme: Associated Issue Type Scheme");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"You are about to delete the Issue Type Scheme named", "Associated Issue Type Scheme"});
        this.tester.assertTextPresent("There is one project (monkey) currently using this scheme. This project will revert to using the default global issue type scheme.");
        this.tester.submit("Delete");
        try {
            WebTable issueTypeSchemesTable = this.tester.getDialog().getResponse().getTableWithID("issuetypeschemes");
            Assert.assertEquals((long)3L, (long)issueTypeSchemesTable.getRowCount());
            this.assertions.getTableAssertions().assertTableRowEquals(issueTypeSchemesTable, 0, new Object[]{"Name", "Options", "Projects", "Actions"});
            this.textAssertions.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), DEFAULT_ISSUE_TYPE_SCHEME_NAME);
            this.textAssertions.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Test Issue Type Scheme");
            this.textAssertions.assertTextNotPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Associated Issue Type Scheme");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("delete_10010");
        this.tester.assertTextPresent("Delete Issue Type Scheme: Test Issue Type Scheme");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"You are about to delete the Issue Type Scheme named", "Test Issue Type Scheme"});
        this.tester.assertTextPresent("There are no projects currently using this scheme.");
        this.tester.submit("Delete");
        try {
            WebTable issueTypeSchemesTable1 = this.tester.getDialog().getResponse().getTableWithID("issuetypeschemes");
            Assert.assertEquals((long)2L, (long)issueTypeSchemesTable1.getRowCount());
            this.assertions.getTableAssertions().assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Options", "Projects", "Actions"});
            this.textAssertions.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), DEFAULT_ISSUE_TYPE_SCHEME_NAME);
            this.textAssertions.assertTextNotPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Test Issue Type Scheme");
            this.textAssertions.assertTextNotPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Associated Issue Type Scheme");
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
    }

    @Test
    public void testIssueTypeSchemeAssociateDefaultScheme() {
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("associate_10000");
        this.tester.assertTextPresent("Associate Issue Type Scheme");
        this.tester.assertTextPresent("Only projects not currently associated with the default scheme are displayed.");
        this.tester.assertOptionsEqual("projects", new String[]{"monkey"});
        this.tester.selectOption("projects", "monkey");
        this.tester.submit("Associate");
        try {
            WebTable issueTypeSchemesTable1 = this.tester.getDialog().getResponse().getTableWithID("issuetypeschemes");
            Assert.assertEquals((long)4L, (long)issueTypeSchemesTable1.getRowCount());
            this.assertions.getTableAssertions().assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Options", "Projects", "Actions"});
            this.assertNoLongerAssociatesWithMky();
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
        this.tester.clickLink("associate_10000");
        this.tester.assertTextPresent("Associate Issue Type Scheme");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"No projects available to be associated with scheme", DEFAULT_ISSUE_TYPE_SCHEME_NAME});
        this.tester.assertFormElementNotPresent("projects");
        this.tester.assertSubmitButtonNotPresent("Associate");
    }

    @Test
    public void testIssueTypeSchemeAssociateSchemeWithProjectAssociation() {
        String projects;
        String schemeName;
        Node[] nodes;
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("associate_10011");
        this.tester.assertTextPresent("Associate Issue Type Scheme");
        this.tester.assertOptionsEqual("projects", new String[]{"homosapien", "monkey"});
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("projects", "monkey");
        this.form.selectOptionsByDisplayName("projects", new String[]{"monkey", "homosapien"});
        this.tester.submit("Associate");
        try {
            WebTable issueTypeSchemesTable = this.tester.getDialog().getResponse().getTableWithID("issuetypeschemes");
            Assert.assertEquals((long)4L, (long)issueTypeSchemesTable.getRowCount());
            this.assertions.getTableAssertions().assertTableRowEquals(issueTypeSchemesTable, 0, new Object[]{"Name", "Options", "Projects", "Actions"});
            for (Node node : nodes = this.locator.css("#issuetypeschemes tbody tr").getNodes()) {
                schemeName = DomKit.getCollapsedText(new CssLocator(node, "td [data-scheme-field=name]").getNode());
                if (!schemeName.equals("Associated Issue Type Scheme")) continue;
                projects = DomKit.getCollapsedText(new CssLocator(node, "td[data-scheme-field=projects]").getNode());
                Assert.assertEquals((Object)projects, (Object)"homosapien monkey");
            }
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
        this.tester.clickLink("associate_10011");
        this.tester.assertTextPresent("Associate Issue Type Scheme");
        this.tester.assertOptionsEqual("projects", new String[]{"homosapien", "monkey"});
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("projects", "monkey");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("projects", "homosapien");
        this.tester.selectOption("projects", "homosapien");
        this.tester.submit("Associate");
        try {
            WebTable issueTypeSchemesTable1 = this.tester.getDialog().getResponse().getTableWithID("issuetypeschemes");
            Assert.assertEquals((long)4L, (long)issueTypeSchemesTable1.getRowCount());
            this.assertions.getTableAssertions().assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Options", "Projects", "Actions"});
            for (Node node : nodes = this.locator.css("#issuetypeschemes tbody tr").getNodes()) {
                schemeName = DomKit.getCollapsedText(new CssLocator(node, "td [data-scheme-field=name]").getNode());
                if (!schemeName.equals("Associated Issue Type Scheme")) continue;
                projects = DomKit.getCollapsedText(new CssLocator(node, "td[data-scheme-field=projects]").getNode());
                Assert.assertEquals((Object)projects, (Object)"homosapien");
            }
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
    }

    @Test
    public void testIssueTypeSchemeAssociateSchemeWithNoProjectAssociation() {
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("associate_10010");
        this.tester.assertTextPresent("Associate Issue Type Scheme");
        this.tester.assertOptionsEqual("projects", new String[]{"homosapien", "monkey"});
        this.form.selectOptionsByDisplayName("projects", new String[]{"monkey"});
        this.tester.submit("Associate");
        try {
            Node[] nodes;
            WebTable issueTypeSchemesTable1 = this.tester.getDialog().getResponse().getTableWithID("issuetypeschemes");
            Assert.assertEquals((long)4L, (long)issueTypeSchemesTable1.getRowCount());
            this.assertions.getTableAssertions().assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Options", "Projects", "Actions"});
            this.assertNoLongerAssociatesWithMky();
            for (Node node : nodes = this.locator.css("#issuetypeschemes tbody tr").getNodes()) {
                String schemeName = DomKit.getCollapsedText(new CssLocator(node, "td [data-scheme-field=name]").getNode());
                if (!schemeName.equals("Test Issue Type Scheme")) continue;
                String projects = DomKit.getCollapsedText(new CssLocator(node, "td[data-scheme-field=projects]").getNode());
                Assert.assertEquals((Object)projects, (Object)"monkey");
            }
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
    }

    private void assertNoLongerAssociatesWithMky() {
        Node[] nodes;
        for (Node node : nodes = this.locator.css("#issuetypeschemes tbody tr").getNodes()) {
            String schemeName = DomKit.getCollapsedText(new CssLocator(node, "td [data-scheme-field=name]").getNode());
            if (!schemeName.equals("Associated Issue Type Scheme")) continue;
            String projects = DomKit.getCollapsedText(new CssLocator(node, "td[data-scheme-field=projects]").getNode());
            Assert.assertEquals((Object)projects, (Object)"No projects");
        }
    }

    @Test
    public void testIssueTypeSchemeCopyValidation() {
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("copy_10000");
        this.tester.assertFormElementEquals("name", "Copy of Default Issue Type Scheme");
        this.tester.assertFormElementEquals("description", DEFAULT_ISSUE_TYPE_SCHEME_DESC);
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("copy_10010");
        this.tester.assertFormElementEquals("name", "Copy of Test Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for test issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("copy_10011");
        this.tester.assertFormElementEquals("name", "Copy of Associated Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for associated issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
    }

    @Test
    public void testIssueTypeSchemeCopy() {
        this.gotoIssueTypeSchemes();
        this.assertCommonIssueTypeSchemesTable(4);
        this.tester.clickLink("copy_10000");
        this.textAssertions.assertTextPresent(this.locator.css("h2"), "Add Issue Type Scheme");
        this.tester.assertFormElementEquals("name", "Copy of Default Issue Type Scheme");
        this.tester.assertFormElementEquals("description", DEFAULT_ISSUE_TYPE_SCHEME_DESC);
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("copy_10010");
        this.textAssertions.assertTextPresent(this.locator.css("h2"), "Add Issue Type Scheme");
        this.tester.assertFormElementEquals("name", "Copy of Test Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for test issue type scheme");
        this.gotoIssueTypeSchemes();
        this.tester.clickLink("copy_10011");
        this.textAssertions.assertTextPresent(this.locator.css("h2"), "Add Issue Type Scheme");
        this.tester.assertFormElementEquals("name", "Copy of Associated Issue Type Scheme");
        this.tester.assertFormElementEquals("description", "Description for associated issue type scheme");
    }

    public void gotoIssueTypeSchemes() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
    }

    public void assertCommonIssueTypeSchemesTable() {
        this.assertCommonIssueTypeSchemesTable(4);
    }

    public void assertCommonIssueTypeSchemesTable(int numberOfRows) {
        try {
            WebTable issueTypeSchemesTable = this.tester.getDialog().getResponse().getTableWithID("issuetypeschemes");
            Assert.assertEquals((long)numberOfRows, (long)issueTypeSchemesTable.getRowCount());
            this.assertions.getTableAssertions().assertTableRowEquals(issueTypeSchemesTable, 0, new Object[]{"Name", "Options", "Projects", "Actions"});
            this.textAssertions.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), DEFAULT_ISSUE_TYPE_SCHEME_NAME);
            this.textAssertions.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Test Issue Type Scheme");
            this.textAssertions.assertTextPresent(this.locator.css("#issuetypeschemes tr td [data-scheme-field=name]"), "Associated Issue Type Scheme");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertIssueTypeSchemeFormValidation() {
        this.tester.assertTextNotPresent("You must select at least one option");
        this.tester.assertTextNotPresent("You must enter a valid name.");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("description", "");
        this.tester.submit("save");
        this.tester.assertTextPresent("You must select at least one option");
        this.tester.assertTextPresent("You must enter a valid name.");
        this.tester.setFormElement("name", "test name");
        this.tester.submit("save");
        this.tester.assertTextPresent("You must select at least one option");
        this.tester.assertTextNotPresent("You must enter a valid name.");
    }
}

