/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@Restore(value="TestEditUserProjectRoles.xml")
public class TestXsrfAdminUsers
extends BaseJiraFuncTest {
    @Inject
    private Form form;
    @Inject
    private Administration administration;

    @Test
    public void testUserOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Properties", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminUsers.this.addProperty();
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Properties", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminUsers.this.addProperty();
                TestXsrfAdminUsers.this.tester.submit("Add");
                TestXsrfAdminUsers.this.tester.clickLink("delete_a");
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("Edit Properties", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminUsers.this.addProperty();
                TestXsrfAdminUsers.this.tester.submit("Add");
                TestXsrfAdminUsers.this.tester.clickLink("edit_a");
                TestXsrfAdminUsers.this.tester.setFormElement("value", "bc");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Add Group", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminUsers.this.administration.usersAndGroups().gotoViewUser("fred");
                TestXsrfAdminUsers.this.tester.clickLink("editgroups_link");
                FormParameterUtil form = new FormParameterUtil(TestXsrfAdminUsers.this.tester, "user-edit-groups", "join");
                form.addOptionToHtmlSelect("groupsToJoin", new String[]{"jira-administrators"});
                form.setFormElement("groupsToJoin", "jira-administrators");
            }
        }, new XsrfCheck.FormSubmission("join")), new XsrfCheck("Remove Group", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminUsers.this.administration.usersAndGroups().gotoViewUser("fred");
                TestXsrfAdminUsers.this.tester.clickLink("editgroups_link");
                TestXsrfAdminUsers.this.tester.selectOption("groupsToLeave", "jira-users");
            }
        }, new XsrfCheck.FormSubmission("leave")), new XsrfCheck("Edit Project Roles", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminUsers.this.administration.usersAndGroups().gotoViewUser("admin");
                TestXsrfAdminUsers.this.tester.clickLink("viewprojectroles_link");
                TestXsrfAdminUsers.this.tester.clickLinkWithText("Edit Project Roles");
                TestXsrfAdminUsers.this.tester.checkCheckbox("10020_10011", "on");
            }
        }, new XsrfCheck.FormSubmission("Save")), new XsrfCheck("Update details", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminUsers.this.administration.usersAndGroups().gotoViewUser("fred");
                TestXsrfAdminUsers.this.tester.clickLinkWithText("Edit Details");
                TestXsrfAdminUsers.this.tester.setFormElement("fullname", "Fred's new name");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Set Password", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminUsers.this.administration.usersAndGroups().gotoViewUser("fred");
                TestXsrfAdminUsers.this.tester.clickLinkWithText("Set Password");
                TestXsrfAdminUsers.this.tester.setFormElement("password", "asdf");
                TestXsrfAdminUsers.this.tester.setFormElement("confirm", "asdf");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete User", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminUsers.this.administration.usersAndGroups().gotoViewUser("fred");
                TestXsrfAdminUsers.this.tester.clickLink("deleteuser_link");
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("Create User", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminUsers.this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
                TestXsrfAdminUsers.this.tester.setFormElement("username", "evil");
                TestXsrfAdminUsers.this.tester.setFormElement("password", "evil");
                TestXsrfAdminUsers.this.tester.setFormElement("fullname", "Totally Evil");
                TestXsrfAdminUsers.this.tester.setFormElement("email", "evil@example.com");
                TestXsrfAdminUsers.this.tester.uncheckCheckbox("sendEmail");
            }
        }, new XsrfCheck.FormSubmission("Create"))).run(this.getTester(), this.navigation, this.form);
    }

    private void addProperty() {
        this.administration.usersAndGroups().gotoViewUser("fred");
        this.tester.clickLinkWithText("Edit Properties");
        this.tester.setFormElement("key", "a");
        this.tester.setFormElement("value", "b");
    }
}

