/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfGlobalPermissions
extends BaseJiraFuncTest {
    @Inject
    private Form form;

    @Test
    public void testGlobalPermissionsAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("AddGlobalPermission", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfGlobalPermissions.this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
                TestXsrfGlobalPermissions.this.tester.setWorkingForm("jiraform");
                TestXsrfGlobalPermissions.this.tester.selectOption("globalPermType", "Browse Users");
                TestXsrfGlobalPermissions.this.tester.selectOption("groupName", "Anyone on the web");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("RemoveGlobalPermission", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfGlobalPermissions.this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
                TestXsrfGlobalPermissions.this.tester.clickLink("del_USER_PICKER_");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.getTester(), this.navigation, this.form);
    }
}

