/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.dashboard.DashboardPageInfo;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfManageDashboards
extends BaseJiraFuncTest {
    @Inject
    private Form form;

    private Dashboard addSharedPublicDashboard() {
        this.backdoor.applicationProperties().enableGlobalSharing();
        return this.navigation.dashboard().addPage(Data.SHARED_PUBLIC_DASHBOARD, null);
    }

    @Test
    public void testDashboardManagementOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Adding Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfManageDashboards.this.navigation.dashboard().navigateToMy();
                TestXsrfManageDashboards.this.tester.clickLink("create_page");
                TestXsrfManageDashboards.this.tester.setWorkingForm("edit-entity");
            }
        }, new XsrfCheck.FormSubmissionWithId("edit-entity-submit")), new XsrfCheck("Restore Default Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfManageDashboards.this.navigation.dashboard().navigateToMy();
                TestXsrfManageDashboards.this.tester.clickLink("restore_defaults");
                TestXsrfManageDashboards.this.tester.setWorkingForm("jiraform");
            }
        }, new XsrfCheck.FormSubmissionWithId("restore_submit"))).run(this.getTester(), this.navigation, this.form);
    }

    @Test
    public void testDashboardOperations() throws Exception {
        this.addSharedPublicDashboard();
        new XsrfTestSuite(new XsrfCheck("Editing Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfManageDashboards.this.navigation.dashboard().navigateToMy();
                TestXsrfManageDashboards.this.tester.clickLink("edit_0");
                TestXsrfManageDashboards.this.tester.setWorkingForm("edit-entity");
            }
        }, new XsrfCheck.FormSubmission("update_submit")), new XsrfCheck("Copy Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfManageDashboards.this.navigation.dashboard().navigateToMy();
                TestXsrfManageDashboards.this.tester.clickLink("clone_0");
                TestXsrfManageDashboards.this.tester.setWorkingForm("edit-entity");
                TestXsrfManageDashboards.this.tester.setFormElement("portalPageName", "New Name");
            }
        }, new XsrfCheck.FormSubmissionWithId("edit-entity-submit")), new XsrfCheck("Delete Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfManageDashboards.this.navigation.dashboard().navigateToMy();
                TestXsrfManageDashboards.this.tester.clickLink("delete_0");
                TestXsrfManageDashboards.this.tester.setWorkingForm("delete-portal-page");
            }
        }, new XsrfCheck.FormSubmissionWithId("delete-portal-page-submit"))).run(this.getTester(), this.navigation, this.form);
    }

    private static class Data {
        private static final DashboardPageInfo SHARED_PUBLIC_DASHBOARD = new DashboardPageInfo(10014L, "Public - Owner: Admin", null, true, TestSharingPermissionUtils.createPublicPermissions(), "admin", 1, DashboardPageInfo.Operation.ALL);

        private Data() {
        }
    }
}

