/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY, Category.WORKFLOW})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfWorkflow
extends BaseJiraFuncTest {
    @Inject
    private Form form;
    @Inject
    private Administration administration;

    String createWorkflow() {
        String workflowId = "WK_" + System.currentTimeMillis();
        this.administration.workflows().goTo();
        this.tester.clickLink("add-workflow");
        this.tester.setFormElement("newWorkflowName", workflowId);
        this.tester.setFormElement("description", "My description");
        return workflowId;
    }

    @Test
    public void testWorkflows() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Workflow", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.createWorkflow();
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Workflow", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOWS);
                TestXsrfWorkflow.this.tester.clickLink("del_" + workflowId);
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("Copy Workflow", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOWS);
                TestXsrfWorkflow.this.tester.clickLink("copy_" + workflowId);
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Rename Workflow", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.administration.workflows().goTo().edit(workflowId).rename().setDescriptionTo("My new description");
            }
        }, new XsrfCheck.FormSubmission("Update"))).run(this.getTester(), this.navigation, this.form);
    }

    private void addTransition() {
        String workflowId = this.createWorkflow();
        this.tester.submit("Add");
        this.administration.workflows().goTo().workflowSteps(workflowId);
        this.tester.clickLink("add_trans_1");
        this.tester.setFormElement("transitionName", "My transition");
        this.tester.setFormElement("description", "My description");
    }

    @Test
    public void testWorkflowSteps() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Delete this Transition", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addTransition();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLinkWithText("My transition");
                TestXsrfWorkflow.this.tester.clickLink("delete_transition");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.getTester(), this.navigation, this.form);
    }

    private void addCondition() {
        this.addTransition();
        this.tester.submit("Add");
        this.tester.clickLinkWithText("My transition");
        this.tester.clickLink("view_conditions");
        this.tester.clickLinkWithText("Add condition", 0);
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-condition");
        this.tester.submit("Add");
    }

    private void addValidator() {
        this.addTransition();
        this.tester.submit("Add");
        this.tester.clickLinkWithText("My transition");
        this.tester.clickLink("view_validators");
        this.tester.clickLinkWithText("Add validator", 0);
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-validator");
        this.tester.submit("Add");
    }

    private void addFunction() {
        this.addTransition();
        this.tester.submit("Add");
        this.tester.clickLinkWithText("My transition");
        this.tester.clickLink("view_post_functions");
        this.tester.clickLinkWithText("Add post function", 0);
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:assigntocurrentuser-function");
    }

    @Test
    public void testWorkflowTransition() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Condition", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addCondition();
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Condition", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addCondition();
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.CssLocatorLinkSubmission("#workflow-conditions .criteria-item .criteria-condition-delete")), new XsrfCheck("Edit Condition", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addCondition();
                TestXsrfWorkflow.this.tester.submit("Add");
                CssLocator locator = new CssLocator(TestXsrfWorkflow.this.getTester(), "#workflow-conditions .criteria-item .criteria-condition-edit");
                Node node = locator.getNode();
                TestXsrfWorkflow.this.tester.gotoPage(((Attr)node.getAttributes().getNamedItem("href")).getValue());
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Switch group condition to OR", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addCondition();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLinkWithText("Add condition", 0);
                TestXsrfWorkflow.this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-condition");
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.CssLocatorLinkSubmission("#workflow-conditions .criteria-group-actions .criteria-toggle-link")), new XsrfCheck("Add Validator", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addValidator();
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Validator", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addValidator();
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.CssLocatorLinkSubmission("#workflow-validators .criteria-item .criteria-validator-delete")), new XsrfCheck("Edit Validator", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addValidator();
                TestXsrfWorkflow.this.tester.submit("Add");
                CssLocator locator = new CssLocator(TestXsrfWorkflow.this.getTester(), "#workflow-validators .criteria-item .criteria-validator-edit");
                Node node = locator.getNode();
                TestXsrfWorkflow.this.tester.gotoPage(((Attr)node.getAttributes().getNamedItem("href")).getValue());
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete Function", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addFunction();
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.CssLocatorLinkSubmission("#workflow-post-functions .criteria-item .criteria-post-function-delete", 1)), new XsrfCheck("Move Function Up", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addFunction();
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.CssLocatorLinkSubmission("#workflow-post-functions .criteria-item .criteria-move-up", 1)), new XsrfCheck("Move Function Down", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addFunction();
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.CssLocatorLinkSubmission("#workflow-post-functions .criteria-item .criteria-move-down", 1)), new XsrfCheck("Edit Generic Function", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addFunction();
                TestXsrfWorkflow.this.tester.submit("Add");
                CssLocator cssLocator = new CssLocator(TestXsrfWorkflow.this.getTester(), "#workflow-post-functions .criteria-item");
                for (Node node : cssLocator.getNodes()) {
                    if (!cssLocator.getText(node).contains("Generic Event")) continue;
                    CssLocator pathLocator = new CssLocator(node, ".criteria-post-function-edit");
                    TestXsrfWorkflow.this.tester.gotoPage(((Attr)pathLocator.getNode().getAttributes().getNamedItem("href")).getValue());
                    return;
                }
                throw new RuntimeException("Unable to edit Generic Event");
            }
        }, new XsrfCheck.FormSubmission("Update"))).run(this.getTester(), this.navigation, this.form);
    }

    @Test
    public void testWorkflowProperties() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add New Property", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.administration.workflows().goTo().workflowSteps(workflowId);
                TestXsrfWorkflow.this.tester.clickLinkWithText("View Properties");
                TestXsrfWorkflow.this.tester.setFormElement("attributeKey", "key");
                TestXsrfWorkflow.this.tester.setFormElement("attributeValue", "value");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Property", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.administration.workflows().goTo().workflowSteps(workflowId);
                TestXsrfWorkflow.this.tester.clickLinkWithText("View Properties");
                TestXsrfWorkflow.this.tester.setFormElement("attributeKey", "myKey");
                TestXsrfWorkflow.this.tester.setFormElement("attributeValue", "value");
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.LinkWithIdSubmission("del_meta_myKey"))).run(this.getTester(), this.navigation, this.form);
    }

    String createStatus() {
        String statusId = "ST_" + System.currentTimeMillis();
        this.navigation.gotoPage("secure/admin/workflows/AddStatus!default.jspa");
        this.tester.setFormElement("name", statusId);
        this.tester.setFormElement("description", "My description");
        return statusId;
    }

    @Test
    public void testWorkflowStatuses() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add New Status", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.createStatus();
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Status", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.createStatus();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLinkWithText("Delete");
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("Edit Status", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.createStatus();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("edit_10003");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Translate Status", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.createStatus();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("view-translation");
                TestXsrfWorkflow.this.tester.setFormElement("jira.translation.Status.1.name", "My Name");
                TestXsrfWorkflow.this.tester.setFormElement("jira.translation.Status.1.desc", "My description");
            }
        }, new XsrfCheck.FormSubmission("update"))).run(this.getTester(), this.navigation, this.form);
    }

    @Test
    public void testXmlImport() throws Exception {
        final String xml = this.administration.workflows().goTo().view("jira").downloadAsXml();
        new XsrfTestSuite(new XsrfCheck("Import XML", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOWS);
                TestXsrfWorkflow.this.tester.clickLinkWithText("Import XML");
                TestXsrfWorkflow.this.tester.setFormElement("name", "myName");
                TestXsrfWorkflow.this.tester.setFormElement("definition", "inline");
                TestXsrfWorkflow.this.tester.setFormElement("workflowXML", xml);
            }
        }, new XsrfCheck.FormSubmission("Import"))).run(this.getTester(), this.navigation, this.form);
    }
}

