/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.trustedapps;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.HttpUnitOptions;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@LoginAs(user="admin")
public class TestTrustedApplications
extends BaseJiraFuncTest {
    private static final String REQUEST_NEW_TRUSTED_APP_DETAILS = "Request New Trusted Application Details";
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.administration.restoreData("TestTrustedAppsBlank.xml");
    }

    @Test
    public void testAdminLinkWorks() {
        this.navigation.gotoAdmin();
        this.gotoViewTrustedAppsConfigs();
        this.tester.assertTextPresent("View Trusted Applications");
        this.tester.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.tester.assertTextPresent("No trusted applications have been configured.");
    }

    private void gotoViewTrustedAppsConfigs() {
        this.tester.gotoPage("/secure/admin/trustedapps/ViewTrustedApplications.jspa");
    }

    @Test
    public void testRequestSelf() {
        String trustedAppName = "theTrustedApplicationName";
        this.navigation.gotoAdmin();
        this.gotoViewTrustedAppsConfigs();
        this.tester.setFormElement("trustedAppBaseUrl", this.getEnvironmentData().getBaseUrl().toExternalForm());
        this.tester.submit("Send Request");
        this.tester.setWorkingForm("jiraform");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.setFormElement("name", "theTrustedApplicationName");
        this.tester.assertTextPresent("Application Name");
        this.tester.assertTextPresent("Application ID");
        this.tester.assertTextPresent("Timeout");
        this.tester.assertTextPresent("IP Address Matches");
        this.tester.assertTextPresent("URL Paths to Allow");
        this.tester.assertButtonNotPresent("Update");
        this.tester.submit("Add");
        this.tester.assertTextPresent("View Trusted Applications");
        this.tester.assertTextPresent("theTrustedApplicationName");
        this.tester.assertLinkPresent("edit-10010");
        this.tester.assertLinkPresent("delete-10010");
        boolean wasEnabled = HttpUnitOptions.isScriptingEnabled();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        try {
            this.tester.clickLink("edit-10010");
            this.tester.setWorkingForm("jiraform");
            this.tester.assertTextPresent("Edit Trusted Application Details");
            this.tester.assertButtonPresent("update_submit");
            this.tester.assertButtonNotPresent("add_submit");
            this.tester.clickLink("cancelButton");
            this.tester.assertTextPresent("View Trusted Applications");
            this.tester.clickLink("delete-10010");
            this.tester.setWorkingForm("jiraform");
            this.tester.assertTextPresent("Delete Trusted Application:");
            this.tester.assertTextPresent("theTrustedApplicationName");
            this.tester.assertButtonPresent("delete_submit");
            this.tester.clickLink("cancelButton");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)wasEnabled);
        }
        this.tester.assertTextPresent("View Trusted Applications");
        this.tester.clickLink("delete-10010");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("View Trusted Applications");
        this.tester.assertTextNotPresent("theTrustedApplicationName");
        this.tester.assertLinkNotPresent("edit-10010");
        this.tester.assertLinkNotPresent("delete-10010");
        this.tester.assertTextPresent("No trusted applications have been configured.");
    }

    @Test
    public void testRequestSelfTwice() {
        this.navigation.gotoAdmin();
        this.gotoViewTrustedAppsConfigs();
        this.tester.setFormElement("trustedAppBaseUrl", this.getEnvironmentData().getBaseUrl().toExternalForm());
        this.tester.submit("Send Request");
        this.tester.setWorkingForm("jiraform");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.setFormElement("name", "theTrustedApplicationName");
        this.tester.submit("Add");
        this.tester.setFormElement("trustedAppBaseUrl", this.getEnvironmentData().getBaseUrl().toExternalForm());
        this.tester.submit("Send Request");
        this.tester.setWorkingForm("jiraform");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.setFormElement("name", "anuvverTrustedApplicationName");
        this.tester.submit("Add");
        this.tester.assertTextPresent("The Trusted Application with the specified applicationId");
        this.tester.assertTextPresent("already exists");
    }

    @Test
    public void testDirectBrowseWithNoPermission() {
        this.navigation.login("regularadmin", "regularadmin");
        this.navigation.gotoAdmin();
        this.tester.assertLinkNotPresent("trusted_apps");
        this.gotoViewTrustedAppsConfigs();
        this.tester.assertTextNotPresent("View Trusted Applications");
        this.tester.gotoPage("/secure/admin/trustedapps/EditTrustedApplication!default.jspa");
        this.tester.assertTextNotPresent("Edit Trusted Application");
        this.tester.gotoPage("/secure/admin/trustedapps/DeleteTrustedApplication!default.jspa");
        this.tester.assertTextNotPresent("Delete Trusted Application");
    }

    @Test
    public void testRequestAppBadUrl() {
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdmin();
        this.gotoViewTrustedAppsConfigs();
        this.tester.setFormElement("trustedAppBaseUrl", "junkUrl-9287349287349");
        this.tester.submit("Send Request");
        this.tester.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.tester.assertTextPresent("java.net.MalformedURLException:");
        String unknownUrl = "http://www.something.invalid/";
        this.tester.setFormElement("trustedAppBaseUrl", "http://www.something.invalid/");
        this.tester.submit("Send Request");
        this.tester.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.tester.assertTextPresent("The host http://www.something.invalid/ could not be found");
        String noTrustUrl = "http://www.google.com";
        this.tester.setFormElement("trustedAppBaseUrl", "http://www.google.com");
        this.tester.submit("Send Request");
        this.tester.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.tester.assertTextPresent("The application at URL http://www.google.com does not support the Trusted Application protocol.");
        String noTrustUrlWhitespace = "   http://www.google.com   ";
        this.tester.setFormElement("trustedAppBaseUrl", "   http://www.google.com   ");
        this.tester.submit("Send Request");
        this.tester.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.tester.assertTextPresent("The application at URL " + "   http://www.google.com   ".trim() + " does not support the Trusted Application protocol.");
        String wrongTrustUrl = this.getUnlistenedURL();
        this.tester.setFormElement("trustedAppBaseUrl", wrongTrustUrl);
        this.tester.submit("Send Request");
        this.tester.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.tester.assertTextPresent("The host " + wrongTrustUrl + " could not be found.");
    }

    @Test
    public void testAddEditValidation() {
        String trustedAppName = "theTrustedApplicationName";
        this.navigation.gotoAdmin();
        this.gotoViewTrustedAppsConfigs();
        this.tester.setFormElement("trustedAppBaseUrl", this.getEnvironmentData().getBaseUrl().toExternalForm());
        this.tester.submit("Send Request");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("name", "");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.assertTextPresent("The Trusted Application Name cannot be blank.");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("name", "theTrustedApplicationName");
        this.tester.setFormElement("timeout", "");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.assertTextPresent("You must specify a positive Timeout value.");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "asdasd");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.assertTextPresent("You must specify a positive Timeout value.");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "-8888");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.assertTextPresent("You must specify a positive Timeout value.");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "0");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.assertTextPresent("You must specify a positive Timeout value.");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "9223372036854775808");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.assertTextPresent("You must specify a positive Timeout value.");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "1000");
        this.tester.setFormElement("ipMatch", "");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.assertTextPresent("You must specify IP addresses to match against.");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "1000");
        this.tester.setFormElement("urlMatch", "");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.tester.assertTextPresent("You must specify URLs to match against.");
        String malformedIp = "blah";
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "1000");
        this.tester.setFormElement("ipMatch", "blah");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.assertBadIPMessage("blah");
        malformedIp = "123.123.123.123.1.1";
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "1000");
        this.tester.setFormElement("ipMatch", "123.123.123.123.1.1");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.assertBadIPMessage("123.123.123.123.1.1");
        malformedIp = "299.299.299.299";
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "1000");
        this.tester.setFormElement("ipMatch", "299.299.299.299");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.assertBadIPMessage("299.299.299.299");
        malformedIp = "192,168,0,1";
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "1000");
        this.tester.setFormElement("ipMatch", "192,168,0,1");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.assertBadIPMessage("192,168,0,1");
        malformedIp = "192.168.?.1";
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "1000");
        this.tester.setFormElement("ipMatch", "192.168.?.1");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Add New Trusted Application");
        this.assertBadIPMessage("192.168.?.1");
        malformedIp = "123.123.123.123\n192.168.0.1";
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("timeout", "1000");
        this.tester.setFormElement("ipMatch", "123.123.123.123\n192.168.0.1");
        this.tester.setFormElement("urlMatch", "/some/url");
        this.tester.submit("Add");
        this.tester.assertTextPresent("View Trusted Applications");
        this.tester.assertTextPresent("theTrustedApplicationName");
        this.tester.assertLinkPresent("delete-10010");
    }

    private void assertBadIPMessage(String malformedIp) {
        this.tester.assertTextPresent("The IP address pattern: " + malformedIp + " is invalid.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUnlistenedURL() {
        String host = "http://localhost:";
        int port = 8000;
        while (true) {
            URL url;
            try {
                url = new URL(host + ++port);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.connect();
            }
            catch (ConnectException e) {
                String string = url.toExternalForm();
                return string;
            }
            catch (IOException iOException) {}
            continue;
            finally {
                if (connection == null) continue;
                connection.disconnect();
                continue;
            }
            break;
        }
    }
}

